/*
 * Decompiled with CFR 0.152.
 */
package ch.carve.microprofile.config.consul;

import org.apache.commons.text.StringSubstitutor;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.spi.ConfigProviderResolver;

public class Configuration {
    private Config config = ConfigProviderResolver.instance().getBuilder().addDefaultSources().build();
    private StringSubstitutor substitutor = new StringSubstitutor(s -> this.getConfigValue(s, ""));
    private String consulHost = this.substitutor.replace(this.getConfigValue("configsource.consul.host", "localhost"));
    private long validity = Long.valueOf(this.getConfigValue("configsource.consul.validity", "30")) * 1000L;
    private String prefix = this.addSlash(this.substitutor.replace(this.getConfigValue("configsource.consul.prefix", "")));

    public long getValidity() {
        return this.validity;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getConsulHost() {
        return this.consulHost;
    }

    private String getConfigValue(String key, String defaultValue) {
        return this.config.getOptionalValue(key, String.class).orElse(defaultValue);
    }

    private String addSlash(String envOrSystemProperty) {
        return envOrSystemProperty.isEmpty() ? "" : envOrSystemProperty + "/";
    }
}

