/*
 * Decompiled with CFR 0.152.
 */
package ch.carve.microprofile.config.consul;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;

public class ExpiringMap<K, V> {
    long validity;
    private Map<K, TimedEntry<V>> cache = new ConcurrentHashMap<K, TimedEntry<V>>();

    public ExpiringMap(long validity) {
        this.validity = validity;
    }

    public V getOrCompute(K propertyName, CheckedFunction<K, V> action, Consumer<K> onException) {
        TimedEntry<V> entry = this.cache.get(propertyName);
        if (entry == null || entry.isExpired()) {
            try {
                V value = action.apply(propertyName);
                this.cache.put(propertyName, new TimedEntry<V>(value));
                return value;
            }
            catch (Exception e) {
                onException.accept(propertyName);
            }
        }
        return entry != null ? (V)entry.getValue() : null;
    }

    Map<K, TimedEntry<V>> getMap() {
        return this.cache;
    }

    @FunctionalInterface
    public static interface CheckedFunction<T, R> {
        public R apply(T var1) throws Exception;
    }

    class TimedEntry<E> {
        private final E value;
        private final long timestamp;

        public TimedEntry(E value) {
            this.value = value;
            this.timestamp = System.currentTimeMillis();
        }

        public E getValue() {
            return this.value;
        }

        public boolean isExpired() {
            return this.timestamp + ExpiringMap.this.validity < System.currentTimeMillis();
        }
    }
}

