/*
 * Decompiled with CFR 0.152.
 */
package ch.carve.microprofile.config.consul;

import ch.carve.microprofile.config.consul.Configuration;
import com.ecwid.consul.v1.ConsulClient;
import com.ecwid.consul.v1.kv.model.GetValue;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.eclipse.microprofile.config.spi.ConfigSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsulConfigSource
implements ConfigSource {
    private static final Logger logger = LoggerFactory.getLogger(ConsulConfigSource.class);
    Configuration config = new Configuration();
    private Map<String, TimedEntry> cache = new ConcurrentHashMap<String, TimedEntry>();
    ConsulClient client = new ConsulClient(this.config.getConsulHost());
    private TimedEntry consulError = null;

    public Map<String, String> getProperties() {
        return this.cache.entrySet().stream().collect(Collectors.toMap(e -> (String)e.getKey(), e -> ((TimedEntry)e.getValue()).getValue()));
    }

    public String getValue(String propertyName) {
        TimedEntry entry = this.cache.get(propertyName);
        if (entry == null || entry.isExpired()) {
            GetValue value;
            block5: {
                logger.debug("load {} from consul", (Object)propertyName);
                value = null;
                try {
                    value = (GetValue)this.client.getKVValue(String.valueOf(this.config.getPrefix()) + propertyName).getValue();
                }
                catch (Exception e) {
                    if (this.consulError == null || this.consulError.isExpired()) {
                        logger.warn("consul getKVValue failed, {}", (Object)e.getMessage());
                        this.consulError = new TimedEntry("");
                    }
                    if (entry == null) break block5;
                    return entry.getValue();
                }
            }
            if (value == null) {
                this.cache.put(propertyName, new TimedEntry(null));
                return null;
            }
            String decodedValue = value.getDecodedValue();
            this.cache.put(propertyName, new TimedEntry(decodedValue));
            return decodedValue;
        }
        return entry.getValue();
    }

    public String getName() {
        return "ConsulConfigSource";
    }

    public int getOrdinal() {
        return 220;
    }

    class TimedEntry {
        private final String value;
        private final long timestamp;

        public TimedEntry(String value) {
            this.value = value;
            this.timestamp = System.currentTimeMillis();
        }

        public String getValue() {
            return this.value;
        }

        public boolean isExpired() {
            return this.timestamp + ConsulConfigSource.this.config.getValidity() < System.currentTimeMillis();
        }
    }
}

