/*
 * Decompiled with CFR 0.152.
 */
package ch.carve.microprofile.config.consul;

import java.util.Optional;
import org.apache.commons.text.StringSubstitutor;

public class Configuration {
    private StringSubstitutor substitutor = new StringSubstitutor(s -> Configuration.getEnvOrSystemProperty(s, ""));
    private String consulHost = this.substitutor.replace(Configuration.getEnvOrSystemProperty("consul.host", "localhost"));
    private long validity = Long.valueOf(Configuration.getEnvOrSystemProperty("consul.configsource.validity", "30")) * 1000L;
    private String prefix = this.addSlash(this.substitutor.replace(Configuration.getEnvOrSystemProperty("consul.prefix", "")));

    public long getValidity() {
        return this.validity;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getConsulHost() {
        return this.consulHost;
    }

    private static String getEnvOrSystemProperty(String key, String defaultValue) {
        return Optional.ofNullable(System.getenv(key)).orElse(System.getProperty(key, defaultValue));
    }

    private String addSlash(String envOrSystemProperty) {
        return envOrSystemProperty.isEmpty() ? "" : String.valueOf(envOrSystemProperty) + "/";
    }
}

