/*
 * Decompiled with CFR 0.152.
 */
package ch.carve.microprofile.config.consul;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;

public class ExpiringMap<K, V> {
    long validity;
    private Map<K, TimedEntry<V>> cache = new ConcurrentHashMap<K, TimedEntry<V>>();

    public ExpiringMap(long validity) {
        this.validity = validity;
    }

    public V getOrCompute(K key, CheckedFunction<K, V> action, Consumer<K> onException) {
        TimedEntry<V> entry = this.cache.get(key);
        if (entry == null || entry.isExpired()) {
            try {
                V value = action.apply(key);
                this.put(key, value);
                return value;
            }
            catch (Exception e) {
                onException.accept(key);
            }
        }
        return entry != null ? (V)entry.get() : null;
    }

    public void put(K key, V value) {
        this.cache.put(key, new TimedEntry<V>(value));
    }

    Map<K, TimedEntry<V>> getMap() {
        return this.cache;
    }

    class TimedEntry<E> {
        private final E value;
        private final long timestamp;

        public TimedEntry(E value) {
            this.value = value;
            this.timestamp = System.currentTimeMillis();
        }

        public E get() {
            return this.value;
        }

        public boolean isExpired() {
            return this.timestamp + ExpiringMap.this.validity < System.currentTimeMillis();
        }
    }

    @FunctionalInterface
    public static interface CheckedFunction<T, R> {
        public R apply(T var1) throws Exception;
    }
}

