/*
 * Decompiled with CFR 0.152.
 */
package ch.carve.microprofile.config.consul;

import ch.carve.microprofile.config.consul.Configuration;
import ch.carve.microprofile.config.consul.ConsulClientWrapper;
import ch.carve.microprofile.config.consul.ExpiringMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.microprofile.config.spi.ConfigSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsulConfigSource
implements ConfigSource {
    private static final Logger logger = LoggerFactory.getLogger(ConsulConfigSource.class);
    private static final String DEFAULT_CONSUL_CONFIGSOURCE_ORDINAL = "550";
    Configuration config = new Configuration();
    ExpiringMap<String, String> cache = new ExpiringMap(this.config.getValidity());
    boolean isDisabled = this.config.getConsulHost().isEmpty() && this.config.getConsulHostList().isEmpty();
    ConsulClientWrapper client = new ConsulClientWrapper(this.config.getConsulHost(), this.config.getConsulHostList(), this.config.getConsulPort(), this.config.getToken());

    public Map<String, String> getProperties() {
        if (!this.isDisabled && this.config.listAll()) {
            List<Map.Entry<String, String>> values = this.client.getKeyValuePairs(this.config.getPrefix());
            values.forEach(v -> this.cache.put((String)v.getKey(), (String)v.getValue()));
        }
        return this.cache.getMap().entrySet().stream().filter(e -> ((ExpiringMap.TimedEntry)e.getValue()).get() != null).collect(Collectors.toMap(e -> (String)e.getKey(), e -> (String)((ExpiringMap.TimedEntry)e.getValue()).get()));
    }

    public String getValue(String propertyName) {
        if (this.isDisabled) {
            return null;
        }
        String value = this.cache.getOrCompute(propertyName, p -> this.client.getValue(this.config.getPrefix() + propertyName), p -> logger.debug("consul getKV failed for key {}", p));
        if ("config_ordinal".equals(propertyName)) {
            return Optional.ofNullable(value).orElse(DEFAULT_CONSUL_CONFIGSOURCE_ORDINAL);
        }
        return value;
    }

    public String getName() {
        return "ConsulConfigSource";
    }
}

