/*
 * Decompiled with CFR 0.152.
 */
package ch.carve.microprofile.config.consul;

import com.ecwid.consul.v1.ConsulClient;
import com.ecwid.consul.v1.Response;
import com.ecwid.consul.v1.kv.model.GetValue;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsulClientWrapper {
    private static final Logger logger = LoggerFactory.getLogger(ConsulClientWrapper.class);
    private String host;
    private List<String> peers = null;
    private int port;
    private String token;
    ConsulClient client = null;

    public ConsulClientWrapper(String host, String hosts, int port, String token) {
        this.host = host;
        if (hosts != null && !hosts.isEmpty()) {
            this.peers = Arrays.asList(hosts.split(","));
        }
        this.port = port;
        this.token = token;
    }

    public ConsulClient getClient() {
        this.initConsulClient();
        return this.client;
    }

    public String getValue(String key) {
        try {
            String encodedKey = URLEncoder.encode(key, StandardCharsets.UTF_8.name());
            GetValue value = this.retry(2, () -> (GetValue)this.getClient().getKVValue(encodedKey, this.token).getValue(), () -> this.forceReconnect());
            return value == null ? null : value.getDecodedValue();
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        catch (Exception e) {
            this.forceReconnect();
            throw e;
        }
    }

    public List<Map.Entry<String, String>> getKeyValuePairs(String prefix) {
        try {
            String encodedPrefix = URLEncoder.encode(prefix, StandardCharsets.UTF_8.name());
            List values = this.retry(2, () -> (List)this.getClient().getKVValues(encodedPrefix, this.token).getValue(), () -> this.forceReconnect());
            return values.stream().map(v -> new AbstractMap.SimpleEntry<String, String>(v.getKey(), v.getDecodedValue())).collect(Collectors.toList());
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        catch (Exception e) {
            this.forceReconnect();
            throw e;
        }
    }

    void initConsulClient() {
        if (this.peers == null) {
            this.client = new ConsulClient(this.host, this.port);
            this.peers = ((List)this.client.getStatusPeers().getValue()).stream().map(s -> s.split(":")[0]).collect(Collectors.toList());
        }
        if (this.client == null) {
            this.client = this.getClientToAnyConsulHost();
        }
    }

    private ConsulClient getClientToAnyConsulHost() {
        return this.peers.stream().map(host -> new ConsulClient(host, this.port)).filter(this::isConsulReachable).findAny().orElseThrow(() -> new RuntimeException("No Consul host could be reached."));
    }

    private boolean isConsulReachable(ConsulClient client) {
        try {
            Response leader = client.getStatusLeader();
            logger.info("Successfully established connection to Consul. Current cluster leader is {}", leader.getValue());
        }
        catch (Exception e) {
            logger.info("Could not establish connection to consul: {}", (Object)e.getMessage());
            return false;
        }
        return true;
    }

    private <T> T retry(int maxRetries, Supplier<T> supplier, Runnable onFailedAttempt) {
        RuntimeException lastException = null;
        for (int retries = 0; retries <= maxRetries; ++retries) {
            try {
                return supplier.get();
            }
            catch (RuntimeException e) {
                lastException = e;
                onFailedAttempt.run();
                continue;
            }
        }
        throw lastException;
    }

    private void forceReconnect() {
        this.client = null;
    }
}

