/*
 * Decompiled with CFR 0.152.
 */
package ch.carve.microprofile.config.consul;

import org.apache.commons.text.StringSubstitutor;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.spi.ConfigProviderResolver;

public class Configuration {
    private Config config = ConfigProviderResolver.instance().getBuilder().addDefaultSources().build();
    private StringSubstitutor substitutor = new StringSubstitutor(s -> this.getConfigValue(s, ""));
    private String consulHost = this.substitutor.replace(this.getConfigValue("configsource.consul.host", ""));
    private String consulHostList = this.substitutor.replace(this.getConfigValue("configsource.consul.hosts", ""));
    private int consulPort = Integer.valueOf(this.substitutor.replace(this.getConfigValue("configsource.consul.port", "8500")));
    private long validity = Long.valueOf(this.getConfigValue("configsource.consul.validity", "30")) * 1000L;
    private String prefix = this.addSlash(this.substitutor.replace(this.getConfigValue("configsource.consul.prefix", "")));
    private String token = this.substitutor.replace(this.getConfigValue("configsource.consul.token", null));
    private boolean listAll = Boolean.valueOf(this.getConfigValue("configsource.consul.list-all", "false"));

    public long getValidity() {
        return this.validity;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getToken() {
        return this.token;
    }

    public String getConsulHost() {
        return this.consulHost;
    }

    public String getConsulHostList() {
        return this.consulHostList;
    }

    public int getConsulPort() {
        return this.consulPort;
    }

    public boolean listAll() {
        return this.listAll;
    }

    private String getConfigValue(String key, String defaultValue) {
        return this.config.getOptionalValue(key, String.class).orElse(defaultValue);
    }

    private String addSlash(String envOrSystemProperty) {
        return envOrSystemProperty.isEmpty() ? "" : envOrSystemProperty + "/";
    }
}

