/*
 * Decompiled with CFR 0.152.
 */
package ch.carve.microprofile.config.consul;

import com.ecwid.consul.v1.ConsulClient;
import com.ecwid.consul.v1.kv.model.GetValue;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.eclipse.microprofile.config.spi.ConfigSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsulConfigSource
implements ConfigSource {
    private static final Logger logger = LoggerFactory.getLogger(ConsulConfigSource.class);
    private Map<String, TimedEntry> cache = new ConcurrentHashMap<String, TimedEntry>();
    private ConsulClient client = new ConsulClient(ConsulConfigSource.getEnvOrSystemProperty("consul.host", "localhost"));
    private long validity = Long.valueOf(ConsulConfigSource.getEnvOrSystemProperty("consul.configsource.validity", "10")) * 1000L;

    public Map<String, String> getProperties() {
        return this.cache.entrySet().stream().collect(Collectors.toMap(e -> (String)e.getKey(), e -> ((TimedEntry)e.getValue()).getValue()));
    }

    public String getValue(String propertyName) {
        TimedEntry entry = this.cache.get(propertyName);
        if (entry == null || entry.isExpired()) {
            logger.debug("load {} from consul", (Object)propertyName);
            GetValue value = null;
            try {
                value = (GetValue)this.client.getKVValue(propertyName).getValue();
            }
            catch (Exception e) {
                logger.warn("consul getKVValue() failed", (Throwable)e);
            }
            if (value == null) {
                this.cache.put(propertyName, new TimedEntry(null));
                return null;
            }
            String decodedValue = value.getDecodedValue();
            this.cache.put(propertyName, new TimedEntry(decodedValue));
            return decodedValue;
        }
        return entry.getValue();
    }

    public String getName() {
        return "ConsulConfigSource";
    }

    public int getOrdinal() {
        return 120;
    }

    private static String getEnvOrSystemProperty(String key, String defaultValue) {
        return Optional.ofNullable(System.getenv(key)).orElse(System.getProperty(key, defaultValue));
    }

    class TimedEntry {
        private final String value;
        private final long timestamp;

        public TimedEntry(String value) {
            this.value = value;
            this.timestamp = System.currentTimeMillis();
        }

        public String getValue() {
            return this.value;
        }

        public boolean isExpired() {
            return this.timestamp + ConsulConfigSource.this.validity < System.currentTimeMillis();
        }
    }
}

