package ch.bullfin.httpmanager.request_queue;

import com.google.gson.Gson;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;

import ch.bullfin.httpmanager.Method;
import ch.bullfin.httpmanager.Part;


/**
 * @author Rahul Raveendran V P
 *         Created on 25/2/15 @ 7:32 PM
 *         https://github.com/rahulrvp
 */
public class Request implements Serializable {
    private long id;
    private String url;
    private Method method;
    private boolean multipart;
    private ArrayList<Part> parts;
    private String paramJson;
    private HashMap<String, Object> urlParams;
    private int pendingRetryCount;
    private long nextRetryTime;

    public Request() {
        multipart = false;
        pendingRetryCount = 1;
        nextRetryTime = 0;
    }

    public HashMap<String, Object> getUrlParams() {
        return urlParams;
    }

    public void setUrlParams(String paramJson) {
        this.urlParams = new Gson().fromJson(paramJson, new HashMap<String, Object>().getClass());
    }

    public String getUrlParamsAsJSON() {
        return new Gson().toJson(urlParams);
    }

    public void setUrlParams(HashMap<String, Object> urlParams) {
        this.urlParams = urlParams;
    }

    public String getParamJson() {
        return paramJson;
    }

    public void setParamJson(String paramJson) {
        this.paramJson = paramJson;
    }

    public ArrayList<Part> getParts() {
        return parts;
    }

    public void setParts(Part[] parts) {
        this.parts = new ArrayList<Part>();
        Collections.addAll(this.parts, parts);
    }

    public void setParts(ArrayList<Part> parts) {
        this.parts = parts;
    }

    public boolean isMultipart() {
        return multipart;
    }

    public void setMultipart(boolean multipart) {
        this.multipart = multipart;
    }

    public Method getMethod() {
        return method;
    }

    public void setMethod(Method method) {
        this.method = method;
    }

    public String getUrl() {
        return url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public long getId() {
        return id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public int getPendingRetryCount() {
        return pendingRetryCount;
    }

    public void setPendingRetryCount(int pendingRetryCount) {
        this.pendingRetryCount = pendingRetryCount;
    }

    public long getNextRetryTime() {
        return nextRetryTime;
    }

    public void setNextRetryTime(long nextRetryTime) {
        this.nextRetryTime = nextRetryTime;
    }
}
