package ch.bullfin.httpmanager;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/**
 * @author Asif Musthafa
 *         Created on 30/07/15 @ 7:38 PM
 *         https://github.com/asifch
 */
public class UrlParams {
    /**
     * generate argument string to append to url
     *
     * @param params map of get/post body
     * @return argument string to append to url
     */
    public static String getUrlParams(final HashMap<String, Object> params) {
        StringBuilder bodyBuilder = new StringBuilder();

        if (params != null) {
            Iterator<Map.Entry<String, Object>> iterator = params.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, Object> param = iterator.next();

                if (param.getValue() instanceof HashMap) {
                    bodyBuilder.append(getInnerParams(param.getKey(), (HashMap<String, Object>) param.getValue()));
                } else if (param.getValue() instanceof List) {
                    bodyBuilder.append(getParam(param.getKey(), getListValue((List) param.getValue())));
                } else {
                    bodyBuilder.append(getParam(param.getKey(), String.valueOf(param.getValue())));
                }

                if (iterator.hasNext()) {
                    bodyBuilder.append('&');
                }
            }
        }

        return bodyBuilder.toString();
    }

    /**
     * Iterates through the passed in List and returns a CSV with the values in it
     *
     * @param list a List object
     * @return CSV of list items
     */
    private static String getListValue(List list) {
        StringBuilder paramBuilder = new StringBuilder();

        if (list != null) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                Object value = iterator.next();
                if (value != null) {
                    paramBuilder.append(String.valueOf(value));

                    if (iterator.hasNext()) {
                        paramBuilder.append(",");
                    }
                }
            }
        }

        return paramBuilder.toString();
    }

    /**
     * method to get params for an inner hash
     *
     * @param key
     * @param value
     * @return param string for the inner hash
     */
    private static String getInnerParams(String key, HashMap<String, Object> value) {
        StringBuilder bodyBuilder = new StringBuilder();

        Iterator<Map.Entry<String, Object>> iterator = value.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, Object> param = iterator.next();
            if (param.getValue().getClass() == String.class) {
                bodyBuilder.append(getParam(key + "[" + param.getKey() + "]", (String) param.getValue()));
            } else if (param.getValue().getClass() == HashMap.class) {
                bodyBuilder.append(getInnerParams(key + "[" + param.getKey() + "]", (HashMap<String, Object>) param.getValue()));
            }
            if (iterator.hasNext()) {
                bodyBuilder.append('&');
            }
        }

        return bodyBuilder.toString();
    }

    /**
     * url encoded string for a param pair
     *
     * @param key
     * @param value
     * @return url encoded param string
     */
    private static String getParam(String key, String value) {
        try {
            return URLEncoder.encode(key, "UTF-8") + "=" + URLEncoder.encode(value, "UTF-8");
        } catch (UnsupportedEncodingException e) {
            return "";
        }
    }
}
