/*
 * Decompiled with CFR 0.152.
 */
package ch.bind.philib.pool.object;

import ch.bind.philib.math.Calc;
import ch.bind.philib.pool.Pool;
import ch.bind.philib.pool.PoolStats;
import ch.bind.philib.pool.manager.ObjectManager;
import ch.bind.philib.pool.object.MultiPoolStats;
import ch.bind.philib.pool.object.PoolBase;
import ch.bind.philib.pool.object.SoftRefPool;
import ch.bind.philib.pool.object.StrongRefPool;
import ch.bind.philib.validation.Validation;
import java.util.concurrent.atomic.AtomicLong;

public final class ConcurrentPool<T>
implements Pool<T> {
    private final PoolThreadLocal poolByThread = new PoolThreadLocal();
    private final PoolBase<T>[] pools;
    private final AtomicLong usageCount = new AtomicLong(0L);
    private final MultiPoolStats stats;

    public ConcurrentPool(ObjectManager<T> manager, int maxEntries, boolean softRefs, int concurrencyLevel) {
        Validation.notNull(manager, "no object manager provided");
        Validation.isTrue(maxEntries > 0, "wont create an empty object pool");
        if (concurrencyLevel < 2) {
            concurrencyLevel = 2;
        }
        int maxPerPool = Calc.ceilDiv(maxEntries, concurrencyLevel);
        this.pools = new PoolBase[concurrencyLevel];
        PoolStats[] s = new PoolStats[concurrencyLevel];
        for (int i = 0; i < concurrencyLevel; ++i) {
            this.pools[i] = softRefs ? new SoftRefPool<T>(manager, maxPerPool) : new StrongRefPool<T>(manager, maxPerPool);
            s[i] = this.pools[i].getPoolStats();
        }
        this.stats = new MultiPoolStats(s);
    }

    @Override
    public T take() {
        return ((PoolBase)this.poolByThread.get()).take();
    }

    @Override
    public void recycle(T value) {
        ((PoolBase)this.poolByThread.get()).recycle(value);
    }

    @Override
    public PoolStats getPoolStats() {
        return this.stats;
    }

    @Override
    public int getNumPooled() {
        int total = 0;
        for (PoolBase<T> pool : this.pools) {
            total += pool.getNumPooled();
        }
        return total;
    }

    @Override
    public void clear() {
        ((PoolBase)this.poolByThread.get()).clear();
    }

    public int getConcurrency() {
        return this.pools.length;
    }

    PoolBase<T> bindToThread() {
        long v = this.usageCount.getAndIncrement();
        int poolIdx = (int)(v % (long)this.pools.length);
        return this.pools[poolIdx];
    }

    private final class PoolThreadLocal
    extends ThreadLocal<PoolBase<T>> {
        private PoolThreadLocal() {
        }

        @Override
        protected PoolBase<T> initialValue() {
            return ConcurrentPool.this.bindToThread();
        }
    }
}

