/*
 * Decompiled with CFR 0.152.
 */
package ch.bind.philib.pool.buffer;

import ch.bind.philib.pool.Pool;
import ch.bind.philib.pool.PoolStats;
import ch.bind.philib.pool.manager.ByteArrayManager;
import ch.bind.philib.pool.object.ConcurrentPool;
import ch.bind.philib.pool.object.SoftRefPool;
import ch.bind.philib.validation.Validation;

public final class ByteArrayPool
implements Pool<byte[]> {
    private final Pool<byte[]> backend;

    public ByteArrayPool(Pool<byte[]> backend) {
        Validation.notNull(backend);
        this.backend = backend;
    }

    @Override
    public final byte[] take() {
        return this.backend.take();
    }

    @Override
    public final void recycle(byte[] value) {
        this.backend.recycle(value);
    }

    @Override
    public final PoolStats getPoolStats() {
        return this.backend.getPoolStats();
    }

    @Override
    public int getNumPooled() {
        return this.backend.getNumPooled();
    }

    @Override
    public void clear() {
        this.backend.clear();
    }

    public static ByteArrayPool create(int bufferSize, int maxEntries) {
        ByteArrayManager manager = new ByteArrayManager(bufferSize);
        return new ByteArrayPool(new SoftRefPool<byte[]>(manager, maxEntries));
    }

    public static ByteArrayPool create(int bufferSize, int maxEntries, int concurrencyLevel) {
        ByteArrayManager manager = new ByteArrayManager(bufferSize);
        if (concurrencyLevel < 2) {
            return new ByteArrayPool(new SoftRefPool<byte[]>(manager, maxEntries));
        }
        return new ByteArrayPool(new ConcurrentPool<byte[]>(manager, maxEntries, true, concurrencyLevel));
    }
}

