/*
 * Decompiled with CFR 0.152.
 */
package ch.bind.philib.util;

import ch.bind.philib.math.Calc;

public final class Counter {
    private final String name;
    private long counts;
    private long total;
    private long min = -1L;
    private long max = -1L;

    public Counter(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public synchronized long getNumCounts() {
        return this.counts;
    }

    public synchronized long getTotal() {
        return this.total;
    }

    public synchronized long getMin() {
        return this.min;
    }

    public synchronized long getMax() {
        return this.max;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void count(long value) {
        if (value < 0L) {
            return;
        }
        Counter counter = this;
        synchronized (counter) {
            long c = this.counts++;
            if (c == 0L) {
                this.min = value;
                this.max = value;
                this.total = value;
            } else {
                this.min = Math.min(this.min, value);
                this.max = Math.max(this.max, value);
                this.total = Calc.unsignedAdd(this.total, value);
            }
        }
    }

    public synchronized void reset() {
        this.counts = 0L;
        this.total = 0L;
        this.min = -1L;
        this.max = -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        long to;
        long ma;
        long mi;
        long c;
        Counter counter = this;
        synchronized (counter) {
            c = this.counts;
            mi = this.min;
            ma = this.max;
            to = this.total;
        }
        if (c == 0L) {
            return String.format("%s[counts=0, total=0, min=N/A, max=N/A, avg=N/A]", this.name);
        }
        double avg = (double)to / (double)c;
        return String.format("%s[counts=%d, total=%d, min=%d, max=%d, avg=%.3f]", this.name, c, to, mi, ma, avg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void count(Counter counter) {
        long to;
        long ma;
        long mi;
        long c;
        Counter counter2 = counter;
        synchronized (counter2) {
            c = counter.counts;
            mi = counter.min;
            ma = counter.max;
            to = counter.total;
        }
        if (c == 0L) {
            return;
        }
        counter2 = this;
        synchronized (counter2) {
            if (this.counts == 0L) {
                this.min = mi;
                this.max = ma;
            } else {
                this.min = Math.min(this.min, mi);
                this.max = Math.max(this.max, ma);
            }
            this.counts += c;
            this.total = Calc.unsignedAdd(this.total, to);
        }
    }
}

