/*
 * Decompiled with CFR 0.152.
 */
package ch.bind.philib.validation;

import java.util.Collection;

public abstract class Validation {
    protected Validation() {
    }

    public static void notNegative(int value) {
        if (value < 0) {
            throw new IllegalArgumentException("value must not be negative");
        }
    }

    public static void notNegative(int value, String message) {
        if (value < 0) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void notNegative(long value) {
        if (value < 0L) {
            throw new IllegalArgumentException("value must not be negative");
        }
    }

    public static void notNegative(long value, String message) {
        if (value < 0L) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void notNull(Object obj) {
        if (obj == null) {
            throw new IllegalArgumentException("object must not be null");
        }
    }

    public static void notNull(Object obj, String message) {
        if (obj == null) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void isTrue(boolean value) {
        if (!value) {
            throw new IllegalArgumentException("value must be true");
        }
    }

    public static void isTrue(boolean value, String message) {
        if (!value) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void isFalse(boolean value) {
        if (value) {
            throw new IllegalArgumentException("value must be false");
        }
    }

    public static void isFalse(boolean value, String message) {
        if (value) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void notNullOrEmpty(CharSequence value) {
        Validation.notNullOrEmpty(value, "null or empty string provided");
    }

    public static void notNullOrEmpty(CharSequence value, String message) {
        if (value == null || value.length() == 0) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void notNullOrEmpty(Collection<?> value) {
        Validation.notNullOrEmpty(value, "null or empty collection provided");
    }

    public static void notNullOrEmpty(Collection<?> value, String message) {
        if (value == null || value.isEmpty()) {
            throw new IllegalArgumentException(message);
        }
    }

    public static <T> void notNullOrEmpty(T[] value) {
        Validation.notNullOrEmpty(value, "null or empty array provided");
    }

    public static <T> void notNullOrEmpty(T[] value, String message) {
        if (value == null || value.length == 0) {
            throw new IllegalArgumentException(message);
        }
    }
}

