/*
 * Decompiled with CFR 0.152.
 */
package ch.bind.philib.lang;

import ch.bind.philib.validation.Validation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ThreadUtil {
    private static final Logger LOG = LoggerFactory.getLogger(ThreadUtil.class);

    protected ThreadUtil() {
    }

    public static void sleepUntilMs(long time) throws InterruptedException {
        long diff = time - System.currentTimeMillis();
        if (diff <= 0L) {
            return;
        }
        Thread.sleep(diff);
    }

    public static boolean interruptAndJoin(Thread t) {
        return ThreadUtil.interruptAndJoin(t, 0L);
    }

    public static boolean interruptAndJoin(Thread t, long waitTime) {
        if (t == null) {
            return true;
        }
        if (!t.isAlive()) {
            return true;
        }
        t.interrupt();
        try {
            if (waitTime <= 0L) {
                t.join();
            } else {
                t.join(waitTime);
            }
        }
        catch (InterruptedException e) {
            LOG.warn("interrupted while waiting for a thread to finish: " + e.getMessage(), (Throwable)e);
        }
        if (t.isAlive()) {
            LOG.warn("thread is still alive: " + t.getName());
            return false;
        }
        return true;
    }

    public static final class ForeverRunner
    implements Runnable {
        private final Runnable runnable;

        public ForeverRunner(Runnable runnable) {
            Validation.notNull(runnable);
            this.runnable = runnable;
        }

        @Override
        public void run() {
            while (true) {
                try {
                    this.runnable.run();
                    return;
                }
                catch (Exception e) {
                    LOG.warn("runnable crashed, restarting it. thread: " + Thread.currentThread().getName(), (Throwable)e);
                    continue;
                }
                catch (Throwable e) {
                    LOG.error("runnable crashed with an error, will not restart. thread: " + Thread.currentThread().getName(), e);
                    continue;
                }
                break;
            }
        }
    }
}

