/*
 * Decompiled with CFR 0.152.
 */
package ch.bind.philib.util;

import ch.bind.philib.math.Calc;

public final class Counter {
    private final String name;
    private long counts;
    private long total;
    private long min = -1L;
    private long max = -1L;

    Counter(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void count(long value) {
        if (value < 0L) {
            return;
        }
        Counter counter = this;
        synchronized (counter) {
            if (this.counts == 0L) {
                this.counts = 1L;
                this.min = value;
                this.max = value;
                this.total = value;
            } else {
                ++this.counts;
                this.min = Math.min(this.min, value);
                this.max = Math.max(this.max, value);
                this.total = Calc.unsignedAdd(this.total, value);
            }
        }
    }

    public synchronized void reset() {
        this.counts = 0L;
        this.total = 0L;
        this.min = -1L;
        this.max = -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        long to;
        long ma;
        long mi;
        long c;
        Counter counter = this;
        synchronized (counter) {
            c = this.counts;
            mi = this.min;
            ma = this.max;
            to = this.total;
        }
        if (c == 0L) {
            return String.format("%s[counts=0, total=0, min=N/A, max=N/A, avg=N/A]", this.name);
        }
        double avg = (double)to / (double)c;
        return String.format("%s[counts=%d, total=%d, min=%d, max=%d, avg=%.3f]", this.name, c, to, mi, ma, avg);
    }
}

