/*
 * Decompiled with CFR 0.152.
 */
package ch.bind.philib.util;

import ch.bind.philib.util.IntPair;
import ch.bind.philib.validation.Validation;
import java.util.Arrays;
import java.util.Collection;
import java.util.NoSuchElementException;

public final class StaticIntMap<T> {
    private final int[] keys;
    private final Object[] values;

    private StaticIntMap(int[] keys, Object[] values) {
        this.keys = keys;
        this.values = values;
    }

    public static <T> StaticIntMap<T> create(Collection<? extends IntPair<T>> elements) {
        Validation.notNullOrEmpty(elements);
        int l = elements.size();
        IntPair[] elems = new IntPair[l];
        elems = elements.toArray(elems);
        return StaticIntMap.init(elems);
    }

    public static <T> StaticIntMap<T> create(IntPair<T>[] elements) {
        Validation.notNullOrEmpty(elements);
        elements = (IntPair[])elements.clone();
        return StaticIntMap.init(elements);
    }

    private static <T> StaticIntMap<T> init(IntPair<?>[] elements) {
        int len = elements.length;
        Arrays.sort(elements, IntPair.KEY_COMPARATOR);
        int[] keys = new int[len];
        Object[] values = new Object[len];
        int prevKey = 0;
        for (int i = 0; i < len; ++i) {
            IntPair<?> elem = elements[i];
            int key = elem.getKey();
            Object value = elem.getValue();
            if (i > 0 && prevKey == key) {
                throw new IllegalArgumentException("duplicate key: " + key);
            }
            prevKey = key;
            keys[i] = key;
            values[i] = value;
        }
        return new StaticIntMap<T>(keys, values);
    }

    public T get(int key) {
        int idx = Arrays.binarySearch(this.keys, key);
        return (T)(idx < 0 ? null : this.values[idx]);
    }

    public T getOrElse(int key, T defaultVal) {
        int idx = Arrays.binarySearch(this.keys, key);
        return (T)(idx < 0 ? defaultVal : this.values[idx]);
    }

    public T getOrThrow(int key) throws NoSuchElementException {
        int idx = Arrays.binarySearch(this.keys, key);
        if (idx < 0) {
            throw new NoSuchElementException("no value found for key: " + key);
        }
        return (T)this.values[idx];
    }

    public boolean containsKey(int key) {
        return Arrays.binarySearch(this.keys, key) >= 0;
    }

    public int size() {
        return this.keys.length;
    }
}

