/*
 * Decompiled with CFR 0.152.
 */
package ch.bind.philib.util;

import ch.bind.philib.util.LruNode;
import ch.bind.philib.validation.Validation;

public final class LruList<E extends LruNode> {
    private final int capacity;
    private final HeadTailNode headTail = new HeadTailNode();
    private int size;

    public LruList(int capacity) {
        Validation.isTrue(capacity > 0, "capacity must be > 0");
        this.capacity = capacity;
        LruList.link(this.headTail, this.headTail);
    }

    public E add(E node) {
        assert (node.getLruPrev() == null && node.getLruNext() == null);
        LruNode afterHead = this.headTail.getLruNext();
        LruList.link(this.headTail, node);
        LruList.link(node, afterHead);
        ++this.size;
        if (this.size <= this.capacity) {
            return null;
        }
        return this.removeTail();
    }

    public void remove(E node) {
        LruNode prev = node.getLruPrev();
        LruNode next = node.getLruNext();
        assert (next != null && prev != null);
        LruList.link(prev, next);
        --this.size;
        node.resetLruNode();
    }

    public E removeTail() {
        if (this.size == 0) {
            return null;
        }
        LruNode node = this.headTail.getLruPrev();
        this.remove(node);
        return (E)node;
    }

    public void moveToHead(E node) {
        assert (this.size > 0);
        LruNode prev = node.getLruPrev();
        LruNode next = node.getLruNext();
        if (prev == this.headTail) {
            return;
        }
        LruList.link(prev, next);
        LruNode afterHead = this.headTail.getLruNext();
        LruList.link(this.headTail, node);
        LruList.link(node, afterHead);
    }

    public void clear() {
        if (this.size > 0) {
            LruNode node = this.headTail.getLruNext();
            while (node != null) {
                LruNode next = node.getLruNext();
                node.resetLruNode();
                node = next;
            }
        }
        this.size = 0;
        LruList.link(this.headTail, this.headTail);
    }

    public int size() {
        return this.size;
    }

    public int capacity() {
        return this.capacity;
    }

    public boolean hasSpace() {
        return this.size < this.capacity;
    }

    private static void link(LruNode first, LruNode second) {
        first.setLruNext(second);
        second.setLruPrev(first);
    }

    static final class HeadTailNode
    implements LruNode {
        private LruNode next;
        private LruNode prev;

        HeadTailNode() {
        }

        @Override
        public void setLruNext(LruNode lruNext) {
            this.next = lruNext;
        }

        @Override
        public void setLruPrev(LruNode lruPrev) {
            this.prev = lruPrev;
        }

        @Override
        public LruNode getLruNext() {
            return this.next;
        }

        @Override
        public LruNode getLruPrev() {
            return this.prev;
        }

        @Override
        public void resetLruNode() {
            this.next = null;
            this.prev = null;
        }
    }
}

