/*
 * Decompiled with CFR 0.152.
 */
package ch.bind.philib.util;

import ch.bind.philib.util.Counter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public final class CounterRepo {
    private static final String DEFAULT_COUNTER_NAME = "default";
    private static final String DEFAULT_UNIT_NAME = "unknown";
    public static final CounterRepo DEFAULT = new CounterRepo();
    private final ConcurrentMap<String, Counter> counters = new ConcurrentHashMap<String, Counter>();

    public Counter forClass(Class<?> clazz) {
        return this.forClass(clazz, null);
    }

    public Counter forClass(Class<?> clazz, String unit) {
        String name = clazz == null ? null : clazz.getName();
        return this.forName(name, unit);
    }

    public Counter forName(String name) {
        return this.forName(name, null);
    }

    public Counter forName(String name, String unit) {
        name = CounterRepo.getOrElse(name, DEFAULT_COUNTER_NAME);
        unit = CounterRepo.getOrElse(unit, DEFAULT_UNIT_NAME);
        Counter counter = (Counter)this.counters.get(name);
        if (counter != null) {
            return counter;
        }
        counter = new Counter(name, unit);
        Counter other = this.counters.putIfAbsent(name, counter);
        return other != null ? other : counter;
    }

    public void remove(String name) {
        this.counters.remove(CounterRepo.getOrElse(name, DEFAULT_COUNTER_NAME));
    }

    public Collection<Counter> getCounters() {
        return new ArrayList<Counter>(this.counters.values());
    }

    private static String getOrElse(String name, String def) {
        return name == null || name.isEmpty() ? def : name;
    }
}

