/*
 * Decompiled with CFR 0.152.
 */
package ch.bind.philib.pool.manager;

import ch.bind.philib.lang.ArrayUtil;
import ch.bind.philib.pool.manager.ObjectManager;
import java.nio.ByteBuffer;

public final class ByteBufferManager
implements ObjectManager<ByteBuffer> {
    public static final boolean DEFAULT_DIRECT_BUFFER = true;
    private final int bufferSize;
    private final boolean directBuffer;

    public ByteBufferManager(int bufferSize) {
        this(bufferSize, true);
    }

    public ByteBufferManager(int bufferSize, boolean directBuffer) {
        this.bufferSize = bufferSize;
        this.directBuffer = directBuffer;
    }

    @Override
    public ByteBuffer create() {
        if (this.directBuffer) {
            return ByteBuffer.allocateDirect(this.bufferSize);
        }
        return ByteBuffer.allocate(this.bufferSize);
    }

    @Override
    public boolean prepareForRecycle(ByteBuffer buf) {
        if (buf.capacity() == this.bufferSize && buf.isDirect() == this.directBuffer) {
            ArrayUtil.memsetZero(buf);
            return true;
        }
        return false;
    }

    @Override
    public void release(ByteBuffer buf) {
    }

    @Override
    public boolean canReuse(ByteBuffer buf) {
        return true;
    }
}

