/*
 * Decompiled with CFR 0.152.
 */
package ch.bind.philib.pool.buffer;

import ch.bind.philib.pool.Pool;
import ch.bind.philib.pool.PoolStats;
import ch.bind.philib.pool.manager.ByteBufferManager;
import ch.bind.philib.pool.object.ConcurrentPool;
import ch.bind.philib.pool.object.SoftRefPool;
import ch.bind.philib.validation.Validation;
import java.nio.ByteBuffer;

public final class ByteBufferPool
implements Pool<ByteBuffer> {
    private final Pool<ByteBuffer> backend;

    public ByteBufferPool(Pool<ByteBuffer> backend) {
        Validation.notNull(backend);
        this.backend = backend;
    }

    @Override
    public final ByteBuffer take() {
        return this.backend.take();
    }

    @Override
    public final void recycle(ByteBuffer value) {
        this.backend.recycle(value);
    }

    @Override
    public final PoolStats getPoolStats() {
        return this.backend.getPoolStats();
    }

    @Override
    public int getNumPooled() {
        return this.backend.getNumPooled();
    }

    @Override
    public void clear() {
        this.backend.clear();
    }

    public static ByteBufferPool create(int bufferSize, int maxEntries) {
        ByteBufferManager manager = new ByteBufferManager(bufferSize);
        return new ByteBufferPool(new SoftRefPool<ByteBuffer>(manager, maxEntries));
    }

    public static ByteBufferPool create(int bufferSize, int maxEntries, int concurrencyLevel) {
        ByteBufferManager manager = new ByteBufferManager(bufferSize);
        if (concurrencyLevel < 2) {
            return new ByteBufferPool(new SoftRefPool<ByteBuffer>(manager, maxEntries));
        }
        return new ByteBufferPool(new ConcurrentPool<ByteBuffer>(manager, maxEntries, true, concurrencyLevel));
    }
}

