/*
 * Decompiled with CFR 0.152.
 */
package ch.bind.philib.lang;

import ch.bind.philib.io.EndianCodec;

public final class MurmurHash {
    static final int MURMUR2_32_SEED = -1756908916;
    private static final int MURMUR2_32_M = 1540483477;
    private static final int MURMUR2_32_R = 24;
    private static final int MURMUR3_32_C1 = -862048943;
    private static final int MURMUR3_32_C2 = 461845907;

    private MurmurHash() {
    }

    public static final int murmur2(byte[] key) {
        int off;
        int len = key.length;
        int limitOffset = len & 0xFFFFFFFC;
        int hash = 0x9747B28C ^ len;
        for (off = 0; off < limitOffset; off += 4) {
            int k = EndianCodec.decodeInt32LE(key, off);
            hash = MurmurHash.murmur2_mmix(hash, k);
        }
        switch (len & 3) {
            case 3: {
                hash ^= (key[off + 2] & 0xFF) << 16;
            }
            case 2: {
                hash ^= (key[off + 1] & 0xFF) << 8;
            }
            case 1: {
                hash ^= key[off] & 0xFF;
                hash *= 1540483477;
            }
        }
        return MurmurHash.murmur2_finalize(hash);
    }

    private static final int murmur2_finalize(int hash) {
        hash ^= hash >>> 13;
        hash *= 1540483477;
        hash ^= hash >>> 15;
        return hash;
    }

    public static final int murmur3(byte[] key) {
        return MurmurHash.murmur3(key, -1756908916);
    }

    public static final int murmur3(byte[] key, int seed) {
        int k;
        int len = key.length;
        int limitOffset = len & 0xFFFFFFFC;
        int off = 0;
        int hash = seed;
        while (off < limitOffset) {
            k = EndianCodec.decodeInt32LE(key, off);
            off += 4;
            hash ^= MurmurHash.murmur3_round32(k);
            hash = Integer.rotateLeft(hash, 13);
            hash = hash * 5 + -430675100;
        }
        k = 0;
        switch (len & 3) {
            case 3: {
                k ^= (key[off + 2] & 0xFF) << 16;
            }
            case 2: {
                k ^= (key[off + 1] & 0xFF) << 8;
            }
            case 1: {
                hash ^= MurmurHash.murmur3_round32(k ^= key[off] & 0xFF);
            }
        }
        hash ^= len;
        hash = MurmurHash.murmur3_fmix32(hash);
        return hash;
    }

    private static final int murmur3_round32(int k) {
        k *= -862048943;
        k = Integer.rotateLeft(k, 15);
        return k *= 461845907;
    }

    private static final int murmur3_fmix32(int hash) {
        hash ^= hash >>> 16;
        hash *= -2048144789;
        hash ^= hash >>> 13;
        hash *= -1028477387;
        hash ^= hash >>> 16;
        return hash;
    }

    public static final long optimize() {
        byte[] b = new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16};
        long s = System.nanoTime();
        for (int i = 0; i < 12000; ++i) {
            MurmurHash.murmur2(b);
            MurmurHash.murmur3(b);
        }
        return System.nanoTime() - s;
    }

    public static final int murmur2a(byte[] key) {
        return MurmurHash.murmur2a(key, -1756908916);
    }

    public static int murmur2a(byte[] key, int hash) {
        int off;
        int len = key.length;
        int limitOffset = len & 0xFFFFFFFC;
        for (off = 0; off < limitOffset; off += 4) {
            int k = EndianCodec.decodeInt32LE(key, off);
            hash = MurmurHash.murmur2_mmix(hash, k);
        }
        int t = 0;
        switch (len & 3) {
            case 3: {
                t ^= (key[off + 2] & 0xFF) << 16;
            }
            case 2: {
                t ^= (key[off + 1] & 0xFF) << 8;
            }
            case 1: {
                t ^= key[off] & 0xFF;
            }
        }
        hash = MurmurHash.murmur2_mmix(hash, t);
        hash = MurmurHash.murmur2_mmix(hash, len);
        return MurmurHash.murmur2_finalize(hash);
    }

    private static final int murmur2_mmix(int hash, int k) {
        k *= 1540483477;
        k ^= k >>> 24;
        hash *= 1540483477;
        return hash ^= (k *= 1540483477);
    }

    public static int murmur2a_8bit(int hash, int v) {
        hash = MurmurHash.murmur2_mmix(hash, v);
        hash = MurmurHash.murmur2_mmix(hash, 1);
        return MurmurHash.murmur2_finalize(hash);
    }

    public static int murmur2a_16bit(int hash, int v) {
        hash = MurmurHash.murmur2_mmix(hash, v);
        hash = MurmurHash.murmur2_mmix(hash, 2);
        return MurmurHash.murmur2_finalize(hash);
    }

    public static int murmur2a_32bit(int hash, int v) {
        hash = MurmurHash.murmur2_mmix(hash, v);
        hash = MurmurHash.murmur2_mmix(hash, 0);
        hash = MurmurHash.murmur2_mmix(hash, 4);
        return MurmurHash.murmur2_finalize(hash);
    }

    public static int murmur2a_64bit(int hash, long v) {
        int lsb = (int)(v & 0xFFFFFFFFFFFFFFFFL);
        int msb = (int)(v >>> 32);
        hash = MurmurHash.murmur2_mmix(hash, lsb);
        hash = MurmurHash.murmur2_mmix(hash, msb);
        hash = MurmurHash.murmur2_mmix(hash, 0);
        hash = MurmurHash.murmur2_mmix(hash, 8);
        return MurmurHash.murmur2_finalize(hash);
    }
}

