/*
 * Decompiled with CFR 0.152.
 */
package ch.bind.philib.io;

import java.nio.ByteBuffer;

public final class BufferUtil {
    private BufferUtil() {
    }

    public static ByteBuffer append(ByteBuffer dst, ByteBuffer src) {
        int inSrc;
        int cap = dst.capacity();
        int pos = dst.position();
        int lim = dst.limit();
        int availableBack = cap - lim;
        if (availableBack >= (inSrc = src.remaining())) {
            dst.position(lim);
            dst.limit(cap);
            dst.put(src);
            dst.position(pos);
            dst.limit(lim + inSrc);
            return dst;
        }
        int inDst = dst.remaining();
        if (pos != 0 && pos + availableBack >= inSrc) {
            dst.compact();
            dst.position(inDst);
            dst.limit(cap);
            dst.put(src);
            dst.flip();
            return dst;
        }
        int required = inDst + inSrc;
        ByteBuffer buf = dst.isDirect() ? ByteBuffer.allocateDirect(required) : ByteBuffer.allocate(required);
        buf.put(dst);
        buf.put(src);
        buf.flip();
        return buf;
    }
}

