/*
 * Decompiled with CFR 0.152.
 */
package ch.bind.philib.cache;

import ch.bind.philib.cache.Cache;
import ch.bind.philib.cache.Cloner;
import ch.bind.philib.cache.StagedCacheEntry;
import ch.bind.philib.math.Calc;
import ch.bind.philib.util.ClusteredHashIndex;
import ch.bind.philib.util.ClusteredIndex;
import ch.bind.philib.util.LruList;
import ch.bind.philib.validation.Validation;

public final class StagedCache<K, V>
implements Cache<K, V> {
    public static final int MIN_CACHE_CAPACITY = 64;
    public static final int DEFAULT_CACHE_CAPACITY = 256;
    public static final double DEFAULT_OLD_GEN_RATIO = 0.25;
    public static final int DEFAULT_OLD_GEN_AFTER_HITS = 10;
    private static final double MIN_OLD_GEN_RATIO = 0.1;
    private static final double MAX_OLD_GEN_RATIO = 0.9;
    private final LruList<StagedCacheEntry<K, V>> lruYoungGen;
    private final LruList<StagedCacheEntry<K, V>> lruOldGen;
    private final ClusteredIndex<K, StagedCacheEntry<K, V>> index;
    private final int oldGenAfterHits;
    private final int capacity;
    private final Cloner<V> valueCloner;

    public StagedCache() {
        this(256);
    }

    public StagedCache(int capacity) {
        this(capacity, null);
    }

    public StagedCache(int capacity, Cloner<V> valueCloner) {
        this(capacity, valueCloner, 0.25, 10);
    }

    public StagedCache(int capacity, Cloner<V> valueCloner, double oldGenRatio, int oldGenAfterHits) {
        this.capacity = Math.max(64, capacity);
        this.oldGenAfterHits = oldGenAfterHits < 1 ? 1 : oldGenAfterHits;
        oldGenRatio = Calc.clip(oldGenRatio, 0.1, 0.9);
        int oldCap = (int)((double)this.capacity * oldGenRatio);
        int youngCap = this.capacity - oldCap;
        this.lruYoungGen = new LruList(youngCap);
        this.lruOldGen = new LruList(oldCap);
        this.index = new ClusteredHashIndex<K, StagedCacheEntry<K, V>>(capacity);
        this.valueCloner = valueCloner;
    }

    @Override
    public void add(K key, V value) {
        Validation.notNull(key);
        StagedCacheEntry<K, V> entry = this.index.get(key);
        if (value == null) {
            if (entry != null) {
                this.removeLruAndIndex(entry);
            }
            return;
        }
        if (entry == null) {
            entry = new StagedCacheEntry<K, V>(key, value);
            this.index.add(entry);
            this.addYoungGen(entry, false);
        } else {
            entry.setValue(value);
        }
    }

    @Override
    public V get(K key) {
        Validation.notNull(key);
        StagedCacheEntry<K, V> entry = this.index.get(key);
        if (entry == null) {
            return null;
        }
        Object value = entry.getValue();
        if (value == null) {
            this.removeLruAndIndex(entry);
            return null;
        }
        if (entry.isInYoungGen()) {
            int hits = entry.recordHit();
            if (hits >= this.oldGenAfterHits) {
                entry.resetHits();
                this.lruYoungGen.remove(entry);
                this.addOldGen(entry);
            } else {
                this.lruYoungGen.moveToHead(entry);
            }
        } else {
            this.lruOldGen.moveToHead(entry);
        }
        return this.valueCloner == null ? value : this.valueCloner.clone(value);
    }

    @Override
    public void remove(K key) {
        Validation.notNull(key);
        this.removeLruAndIndex(this.index.get(key));
    }

    @Override
    public int capacity() {
        return this.capacity;
    }

    @Override
    public void clear() {
        this.lruYoungGen.clear();
        this.lruOldGen.clear();
        this.index.clear();
    }

    private void removeLruAndIndex(StagedCacheEntry<K, V> entry) {
        if (entry != null) {
            this.index.remove(entry);
            if (entry.isInYoungGen()) {
                this.lruYoungGen.remove(entry);
            } else {
                this.lruOldGen.remove(entry);
            }
        }
    }

    private void addYoungGen(StagedCacheEntry<K, V> entry, boolean checkValue) {
        if (checkValue && entry.getValue() == null) {
            this.index.remove(entry);
        } else {
            entry.setInYoungGen();
            StagedCacheEntry<K, V> removed = this.lruYoungGen.add(entry);
            if (removed != null) {
                this.index.remove(removed);
            }
        }
    }

    private void addOldGen(StagedCacheEntry<K, V> entry) {
        if (entry.getValue() == null) {
            this.index.remove(entry);
        } else {
            entry.setInOldGen();
            StagedCacheEntry<K, V> removed = this.lruOldGen.add(entry);
            if (removed != null) {
                this.addYoungGen(removed, true);
            }
        }
    }
}

