/*
 * Decompiled with CFR 0.152.
 */
package ch.bind.philib.cache;

import ch.bind.philib.util.ClusteredIndex;
import ch.bind.philib.util.LruNode;
import java.lang.ref.SoftReference;

class SimpleCacheEntry<K, V>
implements ClusteredIndex.Entry<K>,
LruNode {
    private final K key;
    private SoftReference<V> value;
    private ClusteredIndex.Entry<K> nextIndexEntry;
    private LruNode lruNext;
    private LruNode lruPrev;

    SimpleCacheEntry(K key, V value) {
        this.key = key;
        this.setValue(value);
    }

    @Override
    public K getKey() {
        return this.key;
    }

    V getValue() {
        return this.value.get();
    }

    void setValue(V value) {
        this.value = new SoftReference<V>(value);
    }

    @Override
    public ClusteredIndex.Entry<K> getNextIndexEntry() {
        return this.nextIndexEntry;
    }

    @Override
    public void setNextIndexEntry(ClusteredIndex.Entry<K> nextIndexEntry) {
        this.nextIndexEntry = nextIndexEntry;
    }

    @Override
    public LruNode getLruNext() {
        return this.lruNext;
    }

    @Override
    public void setLruNext(LruNode lruNext) {
        this.lruNext = lruNext;
    }

    @Override
    public LruNode getLruPrev() {
        return this.lruPrev;
    }

    @Override
    public void setLruPrev(LruNode lruPrev) {
        this.lruPrev = lruPrev;
    }

    @Override
    public void resetLruNode() {
        this.lruPrev = null;
        this.lruNext = null;
    }
}

