/*
 * Decompiled with CFR 0.152.
 */
package ch.bind.philib.pool.object;

import ch.bind.philib.pool.manager.ObjectManager;
import ch.bind.philib.pool.object.PoolBase;
import ch.bind.philib.util.LimitedConcurrentQueue;
import java.lang.ref.SoftReference;

public final class SoftRefPool<T>
extends PoolBase<T> {
    private final LimitedConcurrentQueue<SoftReference<T>> queue;

    public SoftRefPool(ObjectManager<T> manager, int maxEntries) {
        super(manager);
        this.queue = new LimitedConcurrentQueue(maxEntries);
    }

    @Override
    protected T poll() {
        SoftReference<T> ref;
        T value;
        do {
            if ((ref = this.queue.poll()) != null) continue;
            return null;
        } while ((value = ref.get()) == null);
        return value;
    }

    @Override
    protected boolean offer(T value) {
        return this.queue.offer(new SoftReference<T>(value));
    }

    @Override
    public int getNumPooled() {
        return this.queue.size();
    }
}

