/*
 * Decompiled with CFR 0.152.
 */
package ch.bind.philib.io;

import java.io.Closeable;
import java.io.IOException;
import java.nio.channels.Selector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SafeCloseUtil {
    private static final Logger LOG = LoggerFactory.getLogger(SafeCloseUtil.class);

    protected SafeCloseUtil() {
    }

    public static void close(Closeable closeable) {
        SafeCloseUtil.close(closeable, null);
    }

    public static void close(Closeable closeable, Logger logger) {
        if (closeable == null) {
            return;
        }
        if (logger == null) {
            logger = LOG;
        }
        try {
            closeable.close();
        }
        catch (IOException e) {
            logger.error("error while closing an object: " + e.getMessage(), (Throwable)e);
        }
    }

    public static void close(Selector selector, Logger logger) {
        if (selector == null) {
            return;
        }
        if (logger == null) {
            logger = LOG;
        }
        try {
            selector.close();
        }
        catch (IOException e) {
            logger.error("error while closing a selector: " + e.getMessage(), (Throwable)e);
        }
    }
}

