/*
 * Decompiled with CFR 0.152.
 */
package ch.bind.philib.cache.buffercache.impl;

import ch.bind.philib.cache.buffercache.impl.ObjectCacheBase;
import ch.bind.philib.cache.buffercache.impl.ObjectFactory;
import ch.bind.philib.validation.Validation;
import java.util.concurrent.atomic.AtomicReference;

public final class LinkedObjectCache<E>
extends ObjectCacheBase<E> {
    private final AtomicReference<Node<E>> freeList;
    private final AtomicReference<Node<E>> objList;
    private final Node<E> LOCK_DUMMY = new Node();

    public LinkedObjectCache(ObjectFactory<E> factory, int maxEntries) {
        super(factory);
        Validation.isTrue(maxEntries > 0);
        this.freeList = new AtomicReference();
        this.objList = new AtomicReference();
        for (int i = 0; i < maxEntries; ++i) {
            Node n = new Node();
            this.put(this.freeList, n);
        }
    }

    @Override
    protected E tryAcquire() {
        Node<E> node = this.take(this.objList);
        if (node == null) {
            return null;
        }
        E e = node.unsetEntry();
        assert (e != null);
        this.put(this.freeList, node);
        return e;
    }

    @Override
    protected boolean tryRelease(E e) {
        Node<E> node = this.take(this.freeList);
        if (node != null) {
            node.setEntry(e);
            this.put(this.objList, node);
            return true;
        }
        return false;
    }

    private final void put(AtomicReference<Node<E>> rootRef, Node<E> newHead) {
        Node<E> tail;
        assert (rootRef != null);
        assert (newHead != null);
        while ((tail = rootRef.get()) == this.LOCK_DUMMY || !rootRef.compareAndSet(tail, this.LOCK_DUMMY)) {
        }
        newHead.setTail(tail);
        boolean ok = rootRef.compareAndSet(this.LOCK_DUMMY, newHead);
        assert (ok);
    }

    private final Node<E> take(AtomicReference<Node<E>> rootRef) {
        Node<E> head;
        assert (rootRef != null);
        do {
            if ((head = rootRef.get()) != null && head != this.LOCK_DUMMY) continue;
            return null;
        } while (!rootRef.compareAndSet(head, this.LOCK_DUMMY));
        Node<E> tail = head.getTail();
        boolean ok = rootRef.compareAndSet(this.LOCK_DUMMY, tail);
        assert (ok);
        return head;
    }

    private static final class Node<E> {
        private volatile Node<E> tail;
        private volatile E entry;

        private Node() {
        }

        void setTail(Node<E> t) {
            this.tail = t;
        }

        Node<E> getTail() {
            return this.tail;
        }

        void setEntry(E e) {
            assert (e != null);
            this.entry = e;
        }

        E unsetEntry() {
            E e = this.entry;
            this.entry = null;
            return e;
        }
    }
}

