/*
 * Decompiled with CFR 0.152.
 */
package ch.bind.philib.util;

public final class Counter {
    private final String name;
    private final String unit;
    private long numAdds;
    private long total;
    private long min = -1L;
    private long max = -1L;

    Counter(String name, String unit) {
        this.name = name;
        this.unit = unit;
    }

    public String getName() {
        return this.name;
    }

    public String getUnit() {
        return this.unit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(long value) {
        if (value <= 0L) {
            return;
        }
        Counter counter = this;
        synchronized (counter) {
            ++this.numAdds;
            long newTotal = this.total + value;
            this.total = newTotal < this.total ? Long.MAX_VALUE : newTotal;
            this.min = this.min == -1L ? value : Math.min(this.min, value);
            this.max = this.max == -1L ? value : Math.max(this.max, value);
        }
    }

    public synchronized void reset() {
        this.numAdds = 0L;
        this.total = 0L;
        this.min = -1L;
        this.max = -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        long to;
        long ma;
        long mi;
        long add;
        Counter counter = this;
        synchronized (counter) {
            add = this.numAdds;
            mi = this.min;
            ma = this.max;
            to = this.total;
        }
        if (add == 0L) {
            return String.format("%s[unit=%s, #adds=0, total=0, min=N/A, max=N/A, avg=N/A]", this.name, this.unit);
        }
        double avg = (double)to / (double)add;
        return String.format("%s[unit=%s, #adds=%d, total=%d, min=%d, max=%d, avg=%.3f]", this.name, this.unit, add, to, mi, ma, avg);
    }
}

