/*
 * Decompiled with CFR 0.152.
 */
package ch.bind.philib.lang;

import ch.bind.philib.validation.Validation;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ThreadUtil {
    private static final Logger LOG = LoggerFactory.getLogger(ThreadUtil.class);
    public static final long DEFAULT_JOIN_TIMEOUT_MS = 1000L;
    private static final AtomicLong FOREVER_RUNNER_SEQ = new AtomicLong(1L);
    private static final String FOREVER_RUNNER_NAME_FMT = "%s-for-%s-%d";

    protected ThreadUtil() {
    }

    public static void sleepUntilMs(long time) throws InterruptedException {
        long diff = time - System.currentTimeMillis();
        if (diff <= 0L) {
            return;
        }
        Thread.sleep(diff);
    }

    public static boolean interruptAndJoin(Thread t) {
        return ThreadUtil.interruptAndJoin(t, 1000L);
    }

    public static boolean interruptAndJoin(Thread t, long waitTime) {
        if (t == null) {
            return true;
        }
        if (!t.isAlive()) {
            return true;
        }
        t.interrupt();
        try {
            t.join(waitTime);
        }
        catch (InterruptedException e) {
            LOG.warn("interrupted while waiting for a thread to finish: " + e.getMessage(), (Throwable)e);
        }
        if (t.isAlive()) {
            LOG.warn("thread is still alive: " + t.getName());
            return false;
        }
        return true;
    }

    public static Thread createForeverRunner(Runnable runnable) {
        Validation.notNull(runnable);
        String threadName = String.format(FOREVER_RUNNER_NAME_FMT, ForeverRunner.class.getSimpleName(), runnable.getClass().getSimpleName(), FOREVER_RUNNER_SEQ.getAndIncrement());
        return ThreadUtil.createForeverRunner(runnable, threadName);
    }

    public static Thread createForeverRunner(Runnable runnable, String threadName) {
        return ThreadUtil.createForeverRunner(null, runnable, threadName);
    }

    public static Thread createForeverRunner(ThreadGroup group, Runnable runnable, String threadName) {
        return ThreadUtil.createForeverRunner(group, runnable, threadName, 0L);
    }

    public static Thread createForeverRunner(ThreadGroup group, Runnable runnable, String threadName, long stackSize) {
        Validation.notNull(runnable);
        Validation.notNull(threadName);
        ForeverRunner runner = new ForeverRunner(threadName, runnable);
        return new Thread(group, runner, threadName, stackSize);
    }

    public static Thread createAndStartForeverRunner(Runnable runnable) {
        return ThreadUtil.start(ThreadUtil.createForeverRunner(runnable));
    }

    public static Thread createAndStartForeverRunner(Runnable runnable, String threadName) {
        return ThreadUtil.start(ThreadUtil.createForeverRunner(runnable, threadName));
    }

    public static Thread createAndStartForeverRunner(ThreadGroup group, Runnable runnable, String threadName) {
        return ThreadUtil.start(ThreadUtil.createForeverRunner(group, runnable, threadName));
    }

    public static Thread createAndStartForeverRunner(ThreadGroup group, Runnable runnable, String threadName, long stackSize) {
        return ThreadUtil.start(ThreadUtil.createForeverRunner(group, runnable, threadName, stackSize));
    }

    private static Thread start(Thread thread) {
        thread.start();
        return thread;
    }

    private static final class ForeverRunner
    implements Runnable {
        private final String threadName;
        private final Runnable runnable;

        public ForeverRunner(String threadName, Runnable runnable) {
            this.threadName = threadName;
            this.runnable = runnable;
        }

        @Override
        public void run() {
            while (true) {
                try {
                    this.runnable.run();
                    return;
                }
                catch (Exception e) {
                    LOG.warn("runnable crashed, restarting it. thread-name=" + this.threadName, (Throwable)e);
                    continue;
                }
                break;
            }
        }
    }
}

