/*
 * Decompiled with CFR 0.152.
 */
package ch.bind.philib.lang;

public abstract class ExceptionUtil {
    protected ExceptionUtil() {
    }

    public static String buildMessageChain(Throwable t) {
        if (t == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder(128);
        ExceptionUtil.add(sb, t);
        for (t = t.getCause(); t != null; t = t.getCause()) {
            sb.append(" => ");
            ExceptionUtil.add(sb, t);
        }
        return sb.toString();
    }

    private static void add(StringBuilder sb, Throwable t) {
        sb.append(t.getClass().getSimpleName());
        StackTraceElement[] trace = t.getStackTrace();
        if (trace != null && trace.length > 0) {
            sb.append('@');
            sb.append(trace[0].toString());
        } else {
            sb.append("@no-stack-trace");
        }
        String msg = t.getMessage();
        if (msg == null) {
            sb.append("()");
        } else {
            sb.append('(');
            sb.append(msg);
            sb.append(')');
        }
    }
}

