/*
 * Decompiled with CFR 0.152.
 */
package ch.bind.philib.concurrency;

import ch.bind.philib.concurrency.Lockable;
import ch.bind.philib.lang.CompareUtil;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Comparator;

public final class LockGroup {
    private static final LockableComparator lockableComparator = new LockableComparator();
    private final Lockable[] objects;

    public LockGroup(Lockable[] objects) {
        if (objects == null || objects.length == 0) {
            throw new IllegalArgumentException("No lockables supplied");
        }
        int n = objects.length;
        this.objects = new Lockable[n];
        System.arraycopy(objects, 0, this.objects, 0, n);
        Arrays.sort(this.objects, lockableComparator);
    }

    public void lock() {
        for (Lockable l : this.objects) {
            l.lock();
        }
    }

    public void unlock() {
        for (Lockable l : this.objects) {
            l.unlock();
        }
    }

    private static final class LockableComparator
    implements Comparator<Lockable>,
    Serializable {
        private static final long serialVersionUID = 157755479046748535L;

        private LockableComparator() {
        }

        @Override
        public int compare(Lockable o1, Lockable o2) {
            long diff = o1.getLockId() - o2.getLockId();
            return CompareUtil.normalize(diff);
        }
    }
}

