/*
 * Decompiled with CFR 0.152.
 */
package ch.bind.philib.util;

import ch.bind.philib.validation.Validation;

public final class LeakyBucket {
    private final long capacity;
    private final long leakIntervalNs;
    private long lastLeakNs;
    private long current;

    private LeakyBucket(long leakIntervalNs, long capacity) {
        this.leakIntervalNs = leakIntervalNs;
        this.capacity = capacity;
    }

    public static LeakyBucket withLeakPerSecond(double leakPerSecond, long capacity) {
        Validation.isTrue(leakPerSecond >= 1.0E-6, "leakPerSecond must be >= 0.000001");
        Validation.isTrue(capacity >= 1L, "capacity must be >= 1");
        long leakIntervalNs = (long)Math.ceil(1.0E9 / leakPerSecond);
        return new LeakyBucket(leakIntervalNs, capacity);
    }

    public static LeakyBucket withLeakIntervalNano(long leakIntervalNs, long capacity) {
        Validation.isTrue(leakIntervalNs > 0L, "leakIntervalNs must be > 0");
        Validation.isTrue(capacity >= 1L, "capacity must be >= 1");
        return new LeakyBucket(leakIntervalNs, capacity);
    }

    public long getCapacity() {
        return this.capacity;
    }

    public void fill(long amount) {
        this.fill(amount, System.nanoTime());
    }

    public void fill(long amount, long timeNs) {
        this.leak(timeNs);
        this.current += amount;
    }

    public long canFill() {
        return this.canFill(System.nanoTime());
    }

    public long canFill(long timeNs) {
        this.leak(timeNs);
        return this.capacity - this.current;
    }

    public long nextFillNano() {
        return this.nextFillNano(System.nanoTime());
    }

    public long nextFillNano(long timeNs) {
        this.leak(timeNs);
        if (this.current < this.capacity) {
            return 0L;
        }
        long nextLeakNano = this.lastLeakNs + this.leakIntervalNs;
        return nextLeakNano - timeNs;
    }

    public void sleepWhileNotFillable() throws InterruptedException {
        long nextFillNano;
        while ((nextFillNano = this.nextFillNano()) > 0L) {
            long sleepMs = nextFillNano / 1000000L;
            int sleepNano = (int)(nextFillNano % 1000000L);
            Thread.sleep(sleepMs, sleepNano);
        }
    }

    private void leak(long timeNs) {
        if (timeNs < this.lastLeakNs) {
            this.lastLeakNs = timeNs;
        } else {
            long diff = timeNs - this.lastLeakNs;
            long canLeak = diff / this.leakIntervalNs;
            if (canLeak > 0L) {
                if (canLeak >= this.current) {
                    this.lastLeakNs = this.leakIntervalNs * this.current;
                    this.current = 0L;
                } else {
                    this.lastLeakNs += this.leakIntervalNs * canLeak;
                    this.current -= canLeak;
                }
            }
            if (this.current == 0L) {
                this.lastLeakNs = timeNs;
            }
        }
    }
}

