/*
 * Decompiled with CFR 0.152.
 */
package ch.bind.philib.io;

import java.nio.ByteBuffer;

public final class BufferOps {
    private static volatile byte[] nullFiller;

    private BufferOps() {
    }

    public static void memsetZero(ByteBuffer buf) {
        if (buf == null) {
            return;
        }
        if (buf.hasArray()) {
            BufferOps.memsetZero(buf.array());
        } else {
            int l;
            byte[] filler = BufferOps.getFiller();
            int filLen = filler.length;
            buf.clear();
            for (int rem = buf.remaining(); rem > 0; rem -= l) {
                l = Math.min(rem, filLen);
                buf.put(filler, 0, l);
            }
            buf.clear();
        }
    }

    public static void memsetZero(byte[] buf) {
        if (buf == null || buf.length == 0) {
            return;
        }
        byte[] filler = BufferOps.getFiller();
        int filLen = filler.length;
        int rem = buf.length;
        int off = 0;
        while (rem > 0) {
            int l = Math.min(rem, filLen);
            BufferOps.memset(filler, buf, off, l);
            rem -= l;
            off += l;
        }
    }

    private static final void memset(byte[] src, byte[] dst, int dstOff, int len) {
        System.arraycopy(src, 0, dst, dstOff, len);
    }

    private static byte[] getFiller() {
        byte[] f = nullFiller;
        if (f == null) {
            nullFiller = f = new byte[8192];
        }
        return f;
    }
}

