/*
 * Decompiled with CFR 0.152.
 */
package ch.bind.philib.cache;

import ch.bind.philib.cache.ObjectCache;
import ch.bind.philib.cache.SpecificCacheBase;
import ch.bind.philib.cache.impl.LinkedObjectCache;
import ch.bind.philib.cache.impl.NoopObjectCache;
import ch.bind.philib.cache.impl.ObjectFactory;
import ch.bind.philib.cache.impl.ScalableObjectCache;
import ch.bind.philib.io.BufferOps;

public final class ByteArrayCache
extends SpecificCacheBase<byte[]> {
    public static final int DEFAULT_BUFFER_SIZE = 8192;
    public static final int DEFAULT_NUM_BUFFERS = 128;

    private ByteArrayCache(ObjectCache<byte[]> cache) {
        super(cache);
    }

    public static ByteArrayCache createSimple(int bufferSize) {
        ObjectFactory<byte[]> factory = ByteArrayCache.createFactory(bufferSize);
        LinkedObjectCache<byte[]> cache = new LinkedObjectCache<byte[]>(factory, 128);
        return new ByteArrayCache((ObjectCache<byte[]>)cache);
    }

    public static ByteArrayCache createSimple(int bufferSize, int maxEntries) {
        ObjectFactory<byte[]> factory = ByteArrayCache.createFactory(bufferSize);
        LinkedObjectCache<byte[]> cache = new LinkedObjectCache<byte[]>(factory, maxEntries);
        return new ByteArrayCache((ObjectCache<byte[]>)cache);
    }

    public static ByteArrayCache createScalable(int bufferSize, int maxEntries) {
        ObjectFactory<byte[]> factory = ByteArrayCache.createFactory(bufferSize);
        ScalableObjectCache<byte[]> cache = new ScalableObjectCache<byte[]>(factory, maxEntries);
        return new ByteArrayCache((ObjectCache<byte[]>)cache);
    }

    public static ByteArrayCache createScalable(int bufferSize, int maxEntries, int bufferBuckets) {
        ObjectFactory<byte[]> factory = ByteArrayCache.createFactory(bufferSize);
        ScalableObjectCache<byte[]> cache = new ScalableObjectCache<byte[]>(factory, maxEntries, bufferBuckets);
        return new ByteArrayCache((ObjectCache<byte[]>)cache);
    }

    public static ByteArrayCache createNoop(int bufferSize) {
        ObjectFactory<byte[]> factory = ByteArrayCache.createFactory(bufferSize);
        NoopObjectCache<byte[]> cache = new NoopObjectCache<byte[]>(factory);
        return new ByteArrayCache((ObjectCache<byte[]>)cache);
    }

    public static ObjectFactory<byte[]> createFactory(int bufferSize) {
        return new ByteArrayFactory(bufferSize);
    }

    private static final class ByteArrayFactory
    implements ObjectFactory<byte[]> {
        private final int bufferSize;

        public ByteArrayFactory(int bufSize) {
            this.bufferSize = bufSize;
        }

        @Override
        public void destroy(byte[] e) {
        }

        @Override
        public byte[] create() {
            return new byte[this.bufferSize];
        }

        @Override
        public boolean prepareForReuse(byte[] e) {
            if (e.length == this.bufferSize) {
                BufferOps.memsetZero(e);
                return true;
            }
            return false;
        }

        @Override
        public boolean canReuse(byte[] e) {
            return true;
        }
    }
}

