/*
 * Decompiled with CFR 0.152.
 */
package ch.bind.philib.validation;

import ch.bind.philib.validation.ValidationException;
import java.io.Serializable;
import java.util.LinkedList;

public final class ValidationResults
implements Serializable {
    static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static final long serialVersionUID = 8465822377127857280L;
    private final LinkedList<String> errors = new LinkedList();

    public int getNumErrors() {
        return this.errors.size();
    }

    public void addError(String message) {
        this.errors.add(message);
    }

    public void addError(String format, Object ... args) {
        this.errors.add(String.format(format, args));
    }

    public boolean validateNotNull(Object testNull, String name) {
        if (testNull == null) {
            this.addError("%s is null", name);
            return false;
        }
        return true;
    }

    public boolean validateMaxLength(String testStr, String name, int maxLength) {
        if (testStr.length() > maxLength) {
            this.addError("%s is too long (%d), the maximum is %d", name, testStr.length(), maxLength);
            return false;
        }
        return true;
    }

    public boolean validateMinLength(String testStr, String name, int minLength) {
        if (testStr.length() < minLength) {
            this.addError("%s is too short (%d), the minimum is %d", name, testStr.length(), minLength);
            return false;
        }
        return true;
    }

    public void checkValidations() throws ValidationException {
        if (this.errors.size() > 0) {
            throw new ValidationException(this);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        int num = 1;
        for (String msg : this.errors) {
            if (num > 1) {
                sb.append(LINE_SEPARATOR);
            }
            sb.append(msg);
            ++num;
        }
        return sb.toString();
    }
}

