/*
 * Decompiled with CFR 0.152.
 */
package ch.bind.philib.test;

import ch.bind.philib.math.Calc;
import ch.bind.philib.test.Bencher;
import ch.bind.philib.validation.Validation;
import java.io.PrintStream;

public final class Bench {
    private static final long DEFAULT_MAX_RUNTIME_MS = 2000L;

    public static Result run(Bencher bencher) throws InterruptedException {
        return Bench.run(bencher, 2000L);
    }

    public static Result run(Bencher bencher, long minRuntimeMs) throws InterruptedException {
        Validation.notNull(bencher);
        long maxRuntimeNs = minRuntimeMs * 1000000L;
        long loops = 10L;
        long timeNs;
        while ((timeNs = Bench.runAndMeasure(bencher, loops)) < maxRuntimeNs) {
            if (timeNs * 8L < maxRuntimeNs) {
                loops *= 8L;
                continue;
            }
            loops *= 2L;
        }
        return new Result(bencher, loops, timeNs);
    }

    public static void runAndPrint(Bencher bencher) throws InterruptedException {
        Bench.run(bencher, 2000L).print(System.out);
    }

    public static void runAndPrint(Bencher bencher, long minRuntimeMs) throws InterruptedException {
        Bench.run(bencher, minRuntimeMs).print(System.out);
    }

    private static long runAndMeasure(Bencher bench, long loops) {
        long t = System.nanoTime();
        bench.run(loops);
        return System.nanoTime() - t;
    }

    public static final class Result {
        private final Bencher bencher;
        private final long loops;
        private final long timeNs;

        public Result(Bencher bencher, long loops, long timeNs) {
            this.bencher = bencher;
            this.loops = loops;
            this.timeNs = timeNs;
        }

        public Bencher getBencher() {
            return this.bencher;
        }

        public long getLoops() {
            return this.loops;
        }

        public long getTimeNs() {
            return this.timeNs;
        }

        public void print(PrintStream printStream) {
            printStream.printf("%-30s %10d ops in %10d ns => %8dns/op\n", this.bencher.getName(), this.loops, this.timeNs, Calc.ceilDiv(this.timeNs, this.loops));
        }
    }
}

