/*
 * Decompiled with CFR 0.152.
 */
package ch.bind.philib.pool.object;

import ch.bind.philib.pool.PoolStats;

final class MultiPoolStats
implements PoolStats {
    private final PoolStats[] stats;

    MultiPoolStats(PoolStats[] stats) {
        this.stats = stats;
    }

    @Override
    public long getCreates() {
        long c = 0L;
        for (PoolStats s : this.stats) {
            c += s.getCreates();
        }
        return c;
    }

    @Override
    public long getTakes() {
        long t = 0L;
        for (PoolStats s : this.stats) {
            t += s.getTakes();
        }
        return t;
    }

    @Override
    public long getRecycled() {
        long r = 0L;
        for (PoolStats s : this.stats) {
            r += s.getRecycled();
        }
        return r;
    }

    @Override
    public long getReleased() {
        long r = 0L;
        for (PoolStats s : this.stats) {
            r += s.getReleased();
        }
        return r;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(256);
        sb.append("pool-total: creates=").append(this.getCreates());
        sb.append(", takes=").append(this.getTakes());
        sb.append(", recycled=").append(this.getRecycled());
        sb.append(", released=").append(this.getReleased());
        for (int i = 0; i < this.stats.length; ++i) {
            sb.append("\n");
            sb.append("  pool-");
            sb.append(i);
            sb.append(": ");
            sb.append(this.stats[i]);
        }
        return sb.toString();
    }
}

