/*
 * Decompiled with CFR 0.152.
 */
package ch.bind.philib.lang;

import ch.bind.philib.lang.ToString;

public abstract class StringUtil {
    public static final String[] EMPTY_STRING_ARRAY = new String[0];

    protected StringUtil() {
    }

    public static String extractBack(String s, char delim) {
        if (s == null || s.isEmpty()) {
            return "";
        }
        int l = s.length();
        int start = 0;
        for (int i = 0; i < l; ++i) {
            char c = s.charAt(i);
            if (c != delim) continue;
            start = i + 1;
        }
        if (start == l) {
            return "";
        }
        return s.substring(start, l);
    }

    public static int count(String str, int value) {
        int off;
        if (str == null || str.length() == 0) {
            return 0;
        }
        int n = 0;
        int fromIdx = 0;
        while ((off = str.indexOf(value, fromIdx)) != -1) {
            fromIdx = off + 1;
            ++n;
        }
        return n;
    }

    public static String[] split(String str, int delimimiter) {
        if (str == null) {
            return EMPTY_STRING_ARRAY;
        }
        int len = str.length();
        if (len == 0) {
            return EMPTY_STRING_ARRAY;
        }
        int n = StringUtil.count(str, delimimiter);
        if (n == 0) {
            return new String[]{str};
        }
        String[] parts = new String[n + 1];
        int i = 0;
        int fromIdx = 0;
        while (true) {
            int off;
            int partLen;
            if ((partLen = (off = str.indexOf(delimimiter, fromIdx)) == -1 ? len - fromIdx : off - fromIdx) > 0) {
                parts[i++] = str.substring(fromIdx, fromIdx + partLen);
            }
            if (off == -1) break;
            fromIdx = off + 1;
        }
        if (i == parts.length) {
            return parts;
        }
        String[] rv = new String[i];
        System.arraycopy(parts, 0, rv, 0, i);
        return rv;
    }

    @Deprecated
    public static StringBuilder start(Object obj) {
        return ToString.start(obj);
    }

    @Deprecated
    public static String end(StringBuilder sb) {
        return ToString.end(sb);
    }

    @Deprecated
    public static void firstObj(StringBuilder sb, String name, Object obj) {
        ToString.first(sb, name, obj);
    }

    @Deprecated
    public static void firstObj(StringBuilder sb, Object obj) {
        ToString.first(sb, obj);
    }

    @Deprecated
    public static void addObj(StringBuilder sb, String name, Object obj) {
        ToString.append(sb, name, obj);
    }

    @Deprecated
    public static void addObj(StringBuilder sb, Object obj) {
        ToString.append(sb, obj);
    }

    @Deprecated
    public static void firstInt(StringBuilder sb, String name, int v) {
        ToString.first(sb, name, v);
    }

    @Deprecated
    public static void addInt(StringBuilder sb, String name, int v) {
        ToString.append(sb, name, v);
    }

    @Deprecated
    public static void addInt(StringBuilder sb, int v) {
        ToString.append(sb, v);
    }

    @Deprecated
    public static void firstLong(StringBuilder sb, String name, long v) {
        ToString.first(sb, name, v);
    }

    @Deprecated
    public static void addLong(StringBuilder sb, String name, long v) {
        ToString.append(sb, name, v);
    }

    @Deprecated
    public static void addLong(StringBuilder sb, long v) {
        ToString.append(sb, v);
    }
}

