/*
 * Decompiled with CFR 0.152.
 */
package ch.bind.philib.lang;

import ch.bind.philib.lang.MurmurHash;

public abstract class HashUtil {
    protected HashUtil() {
    }

    public static int startHash(boolean value) {
        return HashUtil.nextHash(-1756908916, value);
    }

    public static int startHash(byte value) {
        return HashUtil.nextHash(-1756908916, value);
    }

    public static int startHash(char value) {
        return HashUtil.nextHash(-1756908916, value);
    }

    public static int startHash(short value) {
        return HashUtil.nextHash(-1756908916, value);
    }

    public static int startHash(int value) {
        return HashUtil.nextHash(-1756908916, value);
    }

    public static int startHash(long value) {
        return HashUtil.nextHash(-1756908916, value);
    }

    public static int startHash(float value) {
        return HashUtil.nextHash(-1756908916, value);
    }

    public static int startHash(double value) {
        return HashUtil.nextHash(-1756908916, value);
    }

    public static int startHash(Object obj) {
        return HashUtil.nextHash(-1756908916, obj);
    }

    public static int nextHash(int hash, boolean value) {
        return MurmurHash.murmur2a_8bit(hash, value ? 1 : 0);
    }

    public static int nextHash(int hash, byte value) {
        return MurmurHash.murmur2a_8bit(hash, value & 0xFF);
    }

    public static int nextHash(int hash, char value) {
        return MurmurHash.murmur2a_16bit(hash, value);
    }

    public static int nextHash(int hash, short value) {
        return MurmurHash.murmur2a_16bit(hash, value);
    }

    public static int nextHash(int hash, int value) {
        return MurmurHash.murmur2a_32bit(hash, value);
    }

    public static int nextHash(int hash, long value) {
        return MurmurHash.murmur2a_64bit(hash, value);
    }

    public static int nextHash(int hash, float value) {
        return HashUtil.nextHash(hash, HashUtil.fromFloat(value));
    }

    public static int nextHash(int hash, double value) {
        return HashUtil.nextHash(hash, HashUtil.fromDouble(value));
    }

    public static int nextHash(int hash, Object obj) {
        int objHash = obj == null ? 0 : obj.hashCode();
        return MurmurHash.murmur2a_32bit(hash, objHash);
    }

    public static int fromFloat(float value) {
        return Float.floatToIntBits(value);
    }

    public static long fromDouble(double value) {
        return Double.doubleToLongBits(value);
    }
}

