/*
 * Decompiled with CFR 0.152.
 */
package ch.bind.philib.lang;

public abstract class CompareUtil {
    protected CompareUtil() {
    }

    public static boolean equals(Object a, Object b) {
        if (a == b) {
            return true;
        }
        if (a == null) {
            return false;
        }
        return b != null && a.equals(b);
    }

    public static <T> int compare(Comparable<T> a, T b) {
        if (a == b) {
            return 0;
        }
        if (a == null) {
            return -1;
        }
        if (b == null) {
            return 1;
        }
        return a.compareTo(b);
    }

    public static int normalize(int diff) {
        return diff < 0 ? -1 : (diff == 0 ? 0 : 1);
    }

    public static int normalize(long diff) {
        return diff < 0L ? -1 : (diff == 0L ? 0 : 1);
    }

    public static int diff(boolean a, boolean b) {
        return a == b ? 0 : (a ? 1 : -1);
    }

    public static int diff(byte a, byte b) {
        return CompareUtil.diff(a & 0xFF, b & 0xFF);
    }

    public static int diff(char a, char b) {
        return a == b ? 0 : (a < b ? -1 : 1);
    }

    public static int diff(short a, short b) {
        return a == b ? 0 : (a < b ? -1 : 1);
    }

    public static int diff(int a, int b) {
        return a == b ? 0 : (a < b ? -1 : 1);
    }

    public static int diff(long a, long b) {
        return a == b ? 0 : (a < b ? -1 : 1);
    }

    public static int diff(float a, float b) {
        return a == b ? 0 : (a < b ? -1 : 1);
    }

    public static int diff(double a, double b) {
        return a == b ? 0 : (a < b ? -1 : 1);
    }
}

