/*
 * Decompiled with CFR 0.152.
 */
package ch.bind.philib.io;

public final class EndianCodec {
    private EndianCodec() {
    }

    public static void encodeInt64BE(long value, byte[] output) {
        EndianCodec.encodeInt64BE(value, output, 0);
    }

    public static void encodeInt64LE(long value, byte[] output) {
        EndianCodec.encodeInt64LE(value, output, 0);
    }

    public static void encodeInt64BE(long value, byte[] output, int offset) {
        output[offset] = (byte)(value >>> 56 & 0xFFL);
        output[offset + 1] = (byte)(value >> 48 & 0xFFL);
        output[offset + 2] = (byte)(value >> 40 & 0xFFL);
        output[offset + 3] = (byte)(value >> 32 & 0xFFL);
        output[offset + 4] = (byte)(value >> 24 & 0xFFL);
        output[offset + 5] = (byte)(value >> 16 & 0xFFL);
        output[offset + 6] = (byte)(value >> 8 & 0xFFL);
        output[offset + 7] = (byte)(value & 0xFFL);
    }

    public static void encodeInt64LE(long value, byte[] output, int offset) {
        output[offset] = (byte)(value & 0xFFL);
        output[offset + 1] = (byte)(value >> 8 & 0xFFL);
        output[offset + 2] = (byte)(value >> 16 & 0xFFL);
        output[offset + 3] = (byte)(value >> 24 & 0xFFL);
        output[offset + 4] = (byte)(value >> 32 & 0xFFL);
        output[offset + 5] = (byte)(value >> 40 & 0xFFL);
        output[offset + 6] = (byte)(value >> 48 & 0xFFL);
        output[offset + 7] = (byte)(value >>> 56 & 0xFFL);
    }

    public static long decodeInt64BE(byte[] input) {
        return EndianCodec.decodeInt64BE(input, 0);
    }

    public static long decodeInt64LE(byte[] input) {
        return EndianCodec.decodeInt64LE(input, 0);
    }

    public static long decodeInt64BE(byte[] input, int offset) {
        return (long)(input[offset] & 0xFF) << 56 | (long)(input[offset + 1] & 0xFF) << 48 | (long)(input[offset + 2] & 0xFF) << 40 | (long)(input[offset + 3] & 0xFF) << 32 | (long)(input[offset + 4] & 0xFF) << 24 | (long)(input[offset + 5] & 0xFF) << 16 | (long)(input[offset + 6] & 0xFF) << 8 | (long)(input[offset + 7] & 0xFF);
    }

    public static long decodeInt64LE(byte[] input, int offset) {
        return (long)input[offset] & 0xFFL | (long)(input[offset + 1] & 0xFF) << 8 | (long)(input[offset + 2] & 0xFF) << 16 | (long)(input[offset + 3] & 0xFF) << 24 | (long)(input[offset + 4] & 0xFF) << 32 | (long)(input[offset + 5] & 0xFF) << 40 | (long)(input[offset + 6] & 0xFF) << 48 | (long)(input[offset + 7] & 0xFF) << 56;
    }

    public static void encodeInt32BE(int value, byte[] output) {
        EndianCodec.encodeInt32BE(value, output, 0);
    }

    public static void encodeInt32LE(int value, byte[] output) {
        EndianCodec.encodeInt32LE(value, output, 0);
    }

    public static void encodeInt32BE(int value, byte[] output, int offset) {
        output[offset] = (byte)(value >>> 24 & 0xFF);
        output[offset + 1] = (byte)(value >> 16 & 0xFF);
        output[offset + 2] = (byte)(value >> 8 & 0xFF);
        output[offset + 3] = (byte)(value & 0xFF);
    }

    public static void encodeInt32LE(int value, byte[] output, int offset) {
        output[offset] = (byte)(value & 0xFF);
        output[offset + 1] = (byte)(value >> 8 & 0xFF);
        output[offset + 2] = (byte)(value >> 16 & 0xFF);
        output[offset + 3] = (byte)(value >>> 24 & 0xFF);
    }

    public static int decodeInt32BE(byte[] input) {
        return EndianCodec.decodeInt32BE(input, 0);
    }

    public static int decodeInt32LE(byte[] input) {
        return EndianCodec.decodeInt32LE(input, 0);
    }

    public static int decodeInt32BE(byte[] input, int offset) {
        return (input[offset] & 0xFF) << 24 | (input[offset + 1] & 0xFF) << 16 | (input[offset + 2] & 0xFF) << 8 | input[offset + 3] & 0xFF;
    }

    public static int decodeInt32LE(byte[] input, int offset) {
        return input[offset] & 0xFF | (input[offset + 1] & 0xFF) << 8 | (input[offset + 2] & 0xFF) << 16 | (input[offset + 3] & 0xFF) << 24;
    }

    public static void encodeInt16BE(int value, byte[] output) {
        EndianCodec.encodeInt16BE(value, output, 0);
    }

    public static void encodeInt16LE(int value, byte[] output) {
        EndianCodec.encodeInt16LE(value, output, 0);
    }

    public static void encodeInt16BE(int value, byte[] output, int offset) {
        output[offset] = (byte)(value >> 8 & 0xFF);
        output[offset + 1] = (byte)(value & 0xFF);
    }

    public static void encodeInt16LE(int value, byte[] output, int offset) {
        output[offset] = (byte)(value & 0xFF);
        output[offset + 1] = (byte)(value >> 8 & 0xFF);
    }

    public static int decodeInt16BE(byte[] input) {
        return EndianCodec.decodeInt16BE(input, 0);
    }

    public static int decodeInt16LE(byte[] input) {
        return EndianCodec.decodeInt16LE(input, 0);
    }

    public static int decodeInt16BE(byte[] input, int offset) {
        return (input[offset] & 0xFF) << 8 | input[offset + 1] & 0xFF;
    }

    public static int decodeInt16LE(byte[] input, int offset) {
        return input[offset] & 0xFF | (input[offset + 1] & 0xFF) << 8;
    }

    public static void encodeInt8(int value, byte[] output) {
        EndianCodec.encodeInt8(value, output, 0);
    }

    public static void encodeInt8(int value, byte[] output, int offset) {
        output[offset] = (byte)(value & 0xFF);
    }

    public static int decodeInt8(byte[] input) {
        return EndianCodec.decodeInt8(input, 0);
    }

    public static int decodeInt8(byte[] input, int offset) {
        return input[offset] & 0xFF;
    }
}

