/*
 * Decompiled with CFR 0.152.
 */
package ch.bind.philib.conf;

import ch.bind.philib.conf.ConfigListener;
import ch.bind.philib.validation.Validation;
import java.util.HashSet;
import java.util.Set;

public final class FilteringListener
implements ConfigListener {
    private final ConfigListener listener;
    private final Set<String> filteredProperties = new HashSet<String>();
    private boolean blacklist = true;
    private boolean includeChanges = true;
    private boolean includeAdditions = true;
    private boolean includeRemovals = true;

    public FilteringListener(ConfigListener listener) {
        Validation.notNull(listener);
        this.listener = listener;
    }

    @Override
    public void changed(String key, String oldValue, String newValue) {
        if (this.includeChanges && !this.filterMatch(key)) {
            this.listener.changed(key, oldValue, newValue);
        }
    }

    @Override
    public void removed(String key, String oldValue) {
        if (this.includeRemovals && !this.filterMatch(key)) {
            this.listener.removed(key, oldValue);
        }
    }

    @Override
    public void added(String key, String value) {
        if (this.includeAdditions && !this.filterMatch(key)) {
            this.listener.added(key, value);
        }
    }

    public boolean isIncludeChanges() {
        return this.includeChanges;
    }

    public void setIncludeChanges(boolean includeChanges) {
        this.includeChanges = includeChanges;
    }

    public boolean isIncludeAdditions() {
        return this.includeAdditions;
    }

    public void setIncludeAdditions(boolean includeAdditions) {
        this.includeAdditions = includeAdditions;
    }

    public boolean isIncludeRemovals() {
        return this.includeRemovals;
    }

    public void setIncludeRemovals(boolean includeRemovals) {
        this.includeRemovals = includeRemovals;
    }

    public boolean isBlacklist() {
        return this.blacklist;
    }

    public void setBlacklist(boolean blacklist) {
        this.blacklist = blacklist;
    }

    public void addFilterProperty(String key) {
        this.filteredProperties.add(key);
    }

    public void removeFilterProperty(String key) {
        this.filteredProperties.remove(key);
    }

    public boolean filterMatch(String key) {
        boolean contained = this.filteredProperties.contains(key);
        return this.blacklist ? contained : !contained;
    }
}

