/*
 * Decompiled with CFR 0.152.
 */
package ch.bind.philib.util;

import ch.bind.philib.lang.CompareUtil;
import ch.bind.philib.math.Calc;
import ch.bind.philib.util.TimeoutMap;
import ch.bind.philib.validation.Validation;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public final class SimpleTimeoutMap<K, V>
implements TimeoutMap<K, V> {
    private final SortedMap<Long, K> timeoutToKey = new TreeMap<Long, K>();
    private final Map<K, TOEntry<K, V>> keyToValue = new HashMap<K, TOEntry<K, V>>();
    private final ReadWriteLock rwlock = new ReentrantReadWriteLock();
    private final Lock rlock = this.rwlock.readLock();
    private final Lock wlock = this.rwlock.writeLock();
    private final Condition putCond = this.wlock.newCondition();

    @Override
    public V put(long timeout, K key, V value) {
        Validation.notNegative(timeout, "timeout must not be negative");
        long timestampNs = System.nanoTime() + timeout * 1000000L;
        return this._putWithTimestampNs(timestampNs, key, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private V _putWithTimestampNs(long timestampNs, K key, V value) {
        Validation.notNull(key, "key must not be null");
        Validation.notNull(value, "value must not be null");
        this.wlock.lock();
        try {
            TOEntry<K, V> previous = this.keyToValue.remove(key);
            if (previous != null) {
                this.timeoutToKey.remove(previous.timestampNs);
            }
            long actualTimestampNs = timestampNs;
            while (this.timeoutToKey.containsKey(actualTimestampNs)) {
                actualTimestampNs += (long)(Math.random() * 1000.0) + 1L;
            }
            TOEntry<K, V> entry = new TOEntry<K, V>(actualTimestampNs, key, value);
            this.timeoutToKey.put(actualTimestampNs, (Long)key);
            this.keyToValue.put(key, entry);
            this.putCond.signalAll();
            V v = previous == null ? null : (V)previous.value;
            return v;
        }
        finally {
            this.wlock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V get(K key) {
        this.rlock.lock();
        try {
            TOEntry<K, V> entry = this.keyToValue.get(key);
            if (entry != null) {
                Object v = entry.value;
                return v;
            }
            V v = null;
            return v;
        }
        finally {
            this.rlock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V remove(K key) {
        this.wlock.lock();
        try {
            TOEntry<K, V> entry = this.keyToValue.remove(key);
            if (entry != null) {
                long timestampNs = entry.timestampNs;
                Object otherKey = this.timeoutToKey.remove(timestampNs);
                assert (otherKey != null);
                Object v = entry.value;
                return v;
            }
            V v = null;
            return v;
        }
        finally {
            this.wlock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map.Entry<K, V> pollTimeoutNow() {
        this.wlock.lock();
        try {
            Map.Entry<K, V> entry = this._pollTimedoutNs(System.nanoTime());
            return entry;
        }
        finally {
            this.wlock.unlock();
        }
    }

    @Override
    public Map.Entry<K, V> pollTimeoutBlocking() throws InterruptedException {
        return this.pollTimeoutBlocking(0L, TimeUnit.NANOSECONDS);
    }

    @Override
    public Map.Entry<K, V> pollTimeoutBlocking(long duration, TimeUnit timeUnit) throws InterruptedException {
        Validation.notNull((Object)timeUnit);
        long untilNs = duration == 0L ? 0L : System.nanoTime() + timeUnit.toNanos(duration);
        this.wlock.lock();
        try {
            Thread t = Thread.currentThread();
            while (!t.isInterrupted()) {
                long nowNs = System.nanoTime();
                Map.Entry<K, V> entry = this._pollTimedoutNs(nowNs);
                if (entry != null) {
                    Map.Entry<K, V> entry2 = entry;
                    return entry2;
                }
                long nextTimeoutNs = this._getTimeToNextTimeoutNs(nowNs);
                if (untilNs == 0L) {
                    if (nextTimeoutNs == Long.MAX_VALUE) {
                        this.putCond.await();
                        continue;
                    }
                    this.putCond.await(nextTimeoutNs, TimeUnit.NANOSECONDS);
                    continue;
                }
                long awaitTimeoutNs = untilNs - nowNs;
                if (awaitTimeoutNs < 1L) {
                    Map.Entry<K, V> entry3 = null;
                    return entry3;
                }
                awaitTimeoutNs = Math.min(awaitTimeoutNs, nextTimeoutNs);
                this.putCond.await(awaitTimeoutNs, TimeUnit.NANOSECONDS);
            }
            throw new InterruptedException();
        }
        finally {
            this.wlock.unlock();
        }
    }

    private Map.Entry<K, V> _pollTimedoutNs(long timestampNs) {
        if (this.timeoutToKey.isEmpty()) {
            return null;
        }
        Long lowestNs = this.timeoutToKey.firstKey();
        if (timestampNs >= lowestNs) {
            Object key = this.timeoutToKey.remove(lowestNs);
            return this.keyToValue.remove(key);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        this.wlock.lock();
        try {
            this.timeoutToKey.clear();
            this.keyToValue.clear();
        }
        finally {
            this.wlock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        this.rlock.lock();
        try {
            int n = this.keyToValue.size();
            return n;
        }
        finally {
            this.rlock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEmpty() {
        this.rlock.lock();
        try {
            boolean bl = this.keyToValue.isEmpty();
            return bl;
        }
        finally {
            this.rlock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsKey(K key) {
        this.rlock.lock();
        try {
            boolean bl = this.keyToValue.containsKey(key);
            return bl;
        }
        finally {
            this.rlock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getTimeToNextTimeout() {
        this.rlock.lock();
        try {
            long nowNs = System.nanoTime();
            long tNs = this._getTimeToNextTimeoutNs(nowNs);
            if (tNs == 0L) {
                long l = 0L;
                return l;
            }
            if (tNs == Long.MAX_VALUE) {
                long l = Long.MAX_VALUE;
                return l;
            }
            long l = Calc.ceilDiv(tNs, 1000000L);
            return l;
        }
        finally {
            this.rlock.unlock();
        }
    }

    public long _getTimeToNextTimeoutNs(long nowNs) {
        if (this.timeoutToKey.isEmpty()) {
            return Long.MAX_VALUE;
        }
        Long lowest = this.timeoutToKey.firstKey();
        long diff = lowest - nowNs;
        return diff < 0L ? 0L : diff;
    }

    static final class TOEntry<K, V>
    implements Map.Entry<K, V> {
        final long timestampNs;
        final K key;
        final V value;

        TOEntry(long timestampNs, K key, V value) {
            this.timestampNs = timestampNs;
            this.key = key;
            this.value = value;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V value) {
            throw new UnsupportedOperationException("setValue is not supported for entries of a TimeoutMap");
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof Map.Entry) {
                Map.Entry other = (Map.Entry)obj;
                return CompareUtil.equals(this.key, other.getKey()) && CompareUtil.equals(this.value, other.getValue());
            }
            return false;
        }

        @Override
        public int hashCode() {
            return this.key.hashCode() ^ this.value.hashCode();
        }
    }
}

