/*
 * Decompiled with CFR 0.152.
 */
package ch.bind.philib.util;

import ch.bind.philib.math.Calc;

public final class Counter {
    private static final int MAX_NUM_COUNTER_BUCKETS = 8;
    private final String name;
    private long counts;
    private long total;
    private long min = -1L;
    private long max = -1L;
    private final CounterBucket[] buckets;

    public Counter(String name) {
        this.name = name;
        int nBuckets = Math.min(8, Runtime.getRuntime().availableProcessors());
        this.buckets = new CounterBucket[nBuckets];
        for (int i = 0; i < nBuckets; ++i) {
            this.buckets[i] = new CounterBucket();
        }
    }

    public String getName() {
        return this.name;
    }

    public synchronized long getNumCounts() {
        this.aggregate();
        return this.counts;
    }

    public synchronized long getTotal() {
        this.aggregate();
        return this.total;
    }

    public synchronized long getMin() {
        this.aggregate();
        return this.min;
    }

    public synchronized long getMax() {
        this.aggregate();
        return this.max;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void aggregate() {
        CounterBucket[] arr$ = this.buckets;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            CounterBucket cb;
            CounterBucket counterBucket = cb = arr$[i$];
            synchronized (counterBucket) {
                if (cb.counts == 0L) {
                    continue;
                }
                if (this.counts == 0L) {
                    this.min = cb.min;
                    this.max = cb.max;
                } else {
                    this.min = Math.min(this.min, cb.min);
                    this.max = Math.max(this.max, cb.max);
                }
                this.counts += cb.counts;
                this.total += cb.total;
                cb.reset();
                continue;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void count(long value) {
        CounterBucket cb;
        if (value < 0L) {
            return;
        }
        int bucketIdx = (int)(Thread.currentThread().getId() % (long)this.buckets.length);
        CounterBucket counterBucket = cb = this.buckets[bucketIdx];
        synchronized (counterBucket) {
            cb.count(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void count(Counter counter) {
        long to;
        long ma;
        long mi;
        long c;
        if (counter == null) {
            return;
        }
        Counter counter2 = counter;
        synchronized (counter2) {
            counter.aggregate();
            c = counter.counts;
            mi = counter.min;
            ma = counter.max;
            to = counter.total;
        }
        if (c == 0L) {
            return;
        }
        counter2 = this;
        synchronized (counter2) {
            this.aggregate();
            if (this.counts == 0L) {
                this.min = mi;
                this.max = ma;
            } else {
                this.min = Math.min(this.min, mi);
                this.max = Math.max(this.max, ma);
            }
            this.counts += c;
            this.total = Calc.unsignedAdd(this.total, to);
        }
    }

    public synchronized void reset() {
        this.aggregate();
        this.counts = 0L;
        this.total = 0L;
        this.min = -1L;
        this.max = -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        long to;
        long ma;
        long mi;
        long c;
        Counter counter = this;
        synchronized (counter) {
            this.aggregate();
            c = this.counts;
            mi = this.min;
            ma = this.max;
            to = this.total;
        }
        if (c == 0L) {
            return String.format("%s[counts=0, total=0, min=N/A, max=N/A, avg=N/A]", this.name);
        }
        double avg = (double)to / (double)c;
        return String.format("%s[counts=%d, total=%d, min=%d, max=%d, avg=%.3f]", this.name, c, to, mi, ma, avg);
    }

    private static final class CounterBucket {
        private long counts;
        private long total;
        private long min = -1L;
        private long max = -1L;
        private volatile long cacheLinePadding1;
        private volatile long cacheLinePadding2;
        private volatile long cacheLinePadding3;
        private volatile long cacheLinePadding4;

        private CounterBucket() {
        }

        void count(long value) {
            long c;
            if ((c = this.counts++) == 0L) {
                this.min = value;
                this.max = value;
                this.total = value;
            } else {
                this.min = Math.min(this.min, value);
                this.max = Math.max(this.max, value);
                this.total = Calc.unsignedAdd(this.total, value);
            }
        }

        void reset() {
            this.counts = 0L;
            this.total = 0L;
            this.min = 0L;
            this.max = 0L;
        }
    }
}

