/*
 * Decompiled with CFR 0.152.
 */
package ch.bind.philib.lang;

import ch.bind.philib.lang.ArrayUtil;
import ch.bind.philib.validation.Validation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ThreadUtil {
    private static final Logger LOG = LoggerFactory.getLogger(ThreadUtil.class);
    public static final ThreadFactory DEFAULT_THREAD_FACTORY = new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            return new Thread(r);
        }
    };

    protected ThreadUtil() {
    }

    public static void sleepUntilMs(long time) throws InterruptedException {
        long diff = time - System.currentTimeMillis();
        if (diff <= 0L) {
            return;
        }
        Thread.sleep(diff);
    }

    public static boolean interruptAndJoin(Thread t) {
        return ThreadUtil.interruptAndJoin(t, 0L);
    }

    public static boolean interruptAndJoin(Thread t, long waitTime) {
        if (t == null) {
            return true;
        }
        if (!t.isAlive()) {
            return true;
        }
        t.interrupt();
        try {
            if (waitTime <= 0L) {
                t.join();
            } else {
                t.join(waitTime);
            }
        }
        catch (InterruptedException e) {
            LOG.warn("interrupted while waiting for a thread to finish: " + e.getMessage(), (Throwable)e);
        }
        if (t.isAlive()) {
            LOG.warn("thread is still alive: " + t.getName());
            return false;
        }
        return true;
    }

    public static Thread[] createThreads(Runnable[] runnables) {
        return ThreadUtil.createThreads(runnables, DEFAULT_THREAD_FACTORY);
    }

    public static Thread[] createThreads(Runnable[] runnables, ThreadFactory threadFactory) {
        if (runnables == null) {
            return new Thread[0];
        }
        if (threadFactory == null) {
            threadFactory = DEFAULT_THREAD_FACTORY;
        }
        ArrayList<Thread> ts = new ArrayList<Thread>(runnables.length);
        for (Runnable r : runnables) {
            if (r == null) continue;
            ts.add(threadFactory.newThread(r));
        }
        return ArrayUtil.toArray(Thread.class, ts);
    }

    public static boolean interruptAndJoinThreads(Thread[] threads) {
        return ThreadUtil.interruptAndJoinThreads(threads, 0L);
    }

    public static boolean interruptAndJoinThreads(Thread[] threads, long waitTimePerThread) {
        boolean allOk = true;
        if (threads != null && threads.length > 0) {
            for (Thread t : threads) {
                if (ThreadUtil.interruptAndJoin(t, waitTimePerThread)) continue;
                allOk = false;
            }
        }
        return allOk;
    }

    public static boolean interruptAndJoinThreads(Collection<? extends Thread> threads) {
        return ThreadUtil.interruptAndJoinThreads(threads, 0L);
    }

    public static boolean interruptAndJoinThreads(Collection<? extends Thread> threads, long waitTimePerThread) {
        Thread[] ts = ArrayUtil.toArray(Thread.class, threads);
        return ThreadUtil.interruptAndJoinThreads(ts, waitTimePerThread);
    }

    public static void startThreads(Thread[] threads) {
        if (threads != null && threads.length > 0) {
            for (Thread t : threads) {
                if (t == null) continue;
                t.start();
            }
        }
    }

    public static void startThreads(Collection<? extends Thread> threads) {
        Thread[] ts = ArrayUtil.toArray(Thread.class, threads);
        ThreadUtil.startThreads(ts);
    }

    public static final class ForeverRunner
    implements Runnable {
        private final Runnable runnable;

        public ForeverRunner(Runnable runnable) {
            Validation.notNull(runnable);
            this.runnable = runnable;
        }

        @Override
        public void run() {
            while (true) {
                try {
                    this.runnable.run();
                    return;
                }
                catch (Exception e) {
                    LOG.warn("runnable crashed, restarting it. thread: " + Thread.currentThread().getName(), (Throwable)e);
                    continue;
                }
                catch (Throwable e) {
                    LOG.error("runnable crashed with an error, will not restart. thread: " + Thread.currentThread().getName(), e);
                    continue;
                }
                break;
            }
        }
    }
}

