/*
 * Decompiled with CFR 0.152.
 */
package ch.bind.philib.lang;

public final class ServiceState {
    private static final int STATE_UNINITIALIZED = 0;
    private static final int STATE_OPEN = 1;
    private static final int STATE_CLOSING = 2;
    private static final int STATE_CLOSED = 3;
    private volatile int state;

    public boolean isUninitialized() {
        return this.state == 0;
    }

    public boolean isOpen() {
        return this.state == 1;
    }

    public boolean isClosing() {
        return this.state == 2;
    }

    public boolean isClosed() {
        return this.state == 3;
    }

    public boolean isClosingOrClosed() {
        return this.state >= 2;
    }

    public synchronized void setOpen() {
        this.switchState(1);
        this.notifyAll();
    }

    public synchronized void setClosing() {
        this.switchState(2);
        this.notifyAll();
    }

    public synchronized void setClosed() {
        this.switchState(3);
        this.notifyAll();
    }

    public void awaitOpen() throws InterruptedException {
        this.await(1);
    }

    public void awaitClosing() throws InterruptedException {
        this.await(2);
    }

    public void awaitClosed() throws InterruptedException {
        this.await(3);
    }

    private synchronized void await(int waitForState) throws InterruptedException {
        while (this.state < waitForState) {
            this.wait();
        }
    }

    private void switchState(int newState) {
        if (newState < this.state) {
            throw new IllegalStateException("service-states can only be moved forward");
        }
        this.state = newState;
    }
}

