/*
 * Decompiled with CFR 0.152.
 */
package ch.bind.philib.cache;

import ch.bind.philib.cache.Cache;
import ch.bind.philib.lang.Cloner;
import ch.bind.philib.lang.MurmurHash;
import ch.bind.philib.validation.Validation;
import java.lang.ref.SoftReference;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReferenceArray;

public final class LineCache<K, V>
implements Cache<K, V> {
    static final int DEFAULT_ORDER = 8;
    private final AtomicReferenceArray<Entry<K, V>> entries;
    private final int lineMask;
    private final int order;
    private final Cloner<V> valueCloner;

    public LineCache() {
        this(256, 8, null);
    }

    public LineCache(int capacity, int order) {
        this(capacity, order, null);
    }

    public LineCache(Cloner<V> valueCloner) {
        this(256, 8, valueCloner);
    }

    public LineCache(int capacity, int order, Cloner<V> valueCloner) {
        Validation.isTrue(capacity > 0 && order > 0, "capacity and order must be greater than zero");
        Validation.isTrue(Integer.bitCount(order) == 1, "order must be a power of two");
        Validation.isTrue(capacity % order == 0, "capacity must be a multiple of order");
        int lines = capacity / order;
        this.order = order;
        this.entries = new AtomicReferenceArray(capacity);
        this.valueCloner = valueCloner;
        this.lineMask = lines - 1;
    }

    @Override
    public void set(K key, V value) {
        Entry<K, V> overwrite;
        int insertIdx;
        Validation.notNull(key);
        Validation.notNull(value);
        int hash = LineCache.hash(key);
        int line = Math.abs(hash) & this.lineMask;
        int startIdx = line * this.order;
        Entry<K, V> newe = new Entry<K, V>(key, hash, value);
        block0: do {
            insertIdx = -1;
            overwrite = null;
            for (int o = 0; o < this.order; ++o) {
                int idx = startIdx + o;
                Entry<K, V> e = this.entries.get(idx);
                if (e == null) {
                    if (overwrite == null && insertIdx != -1) continue;
                    insertIdx = idx;
                    overwrite = null;
                    continue;
                }
                if (e.matches(key, hash)) {
                    if (!this.entries.compareAndSet(idx, e, newe)) continue block0;
                    return;
                }
                if (insertIdx == -1) {
                    insertIdx = idx;
                    overwrite = e;
                    continue;
                }
                if (overwrite == null || e.lastAccess.get() >= overwrite.lastAccess.get()) continue;
                insertIdx = idx;
                overwrite = e;
            }
        } while (!this.entries.compareAndSet(insertIdx, overwrite, newe));
    }

    private static final int hash(Object o) {
        return MurmurHash.murmur3_finalize_mix32(o.hashCode());
    }

    @Override
    public V get(K key) {
        Validation.notNull(key);
        int hash = LineCache.hash(key);
        int line = Math.abs(hash) & this.lineMask;
        int startIdx = line * this.order;
        for (int o = 0; o < this.order; ++o) {
            int idx = startIdx + o;
            Entry<K, V> e = this.entries.get(idx);
            if (e == null || !e.matches(key, hash)) continue;
            Object value = e.value.get();
            if (value == null) {
                this.entries.compareAndSet(idx, e, null);
                return null;
            }
            e.setLastAccessMaxVal(System.nanoTime());
            return this.valueCloner == null ? value : this.valueCloner.clone(value);
        }
        return null;
    }

    @Override
    public void remove(K key) {
        Validation.notNull(key);
        int hash = LineCache.hash(key);
        int line = Math.abs(hash) & this.lineMask;
        int startIdx = line * this.order;
        for (int o = 0; o < this.order; ++o) {
            int idx = startIdx + o;
            Entry<K, V> e = this.entries.get(idx);
            if (e == null || !e.matches(key, hash)) continue;
            this.entries.compareAndSet(idx, e, null);
            return;
        }
    }

    @Override
    public int capacity() {
        return this.entries.length();
    }

    @Override
    public void clear() {
        int cap = this.entries.length();
        for (int i = 0; i < cap; ++i) {
            this.entries.lazySet(i, null);
        }
        this.entries.set(0, null);
    }

    private static final class Entry<K, V> {
        final K key;
        final int hash;
        final AtomicLong lastAccess = new AtomicLong();
        final SoftReference<V> value;

        public Entry(K key, int hash, V value) {
            this.key = key;
            this.hash = hash;
            this.value = new SoftReference<V>(value);
        }

        public void setLastAccessMaxVal(long access) {
            long v = this.lastAccess.get();
            while (access > v) {
                if (this.lastAccess.compareAndSet(v, access)) {
                    return;
                }
                v = this.lastAccess.get();
            }
        }

        boolean matches(K k, int h) {
            return this.hash == h && (this.key == k || this.key.equals(k));
        }
    }
}

