/*
 * Decompiled with CFR 0.152.
 */
package ch.bind.philib.util;

import ch.bind.philib.util.Counter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public final class CounterRepo {
    private static final String DEFAULT_NAME = "default";
    private static final char POSTFIX_SEP = ':';
    public static final CounterRepo DEFAULT = new CounterRepo();
    private final ConcurrentMap<String, Counter> counters = new ConcurrentHashMap<String, Counter>();

    public Counter forClass(Class<?> clazz) {
        return this.get(CounterRepo.nameOf(clazz));
    }

    public Counter forClass(Class<?> clazz, String postfix) {
        return this.get(CounterRepo.nameOf(clazz, postfix));
    }

    public Counter forName(String name) {
        return this.get(CounterRepo.nameOf(name));
    }

    public Counter forName(String name, String postfix) {
        return this.get(CounterRepo.nameOf(name, postfix));
    }

    private Counter get(String realName) {
        Counter counter = (Counter)this.counters.get(realName);
        if (counter != null) {
            return counter;
        }
        counter = new Counter(realName);
        Counter other = this.counters.putIfAbsent(realName, counter);
        return other != null ? other : counter;
    }

    public void remove(String name) {
        this.counters.remove(CounterRepo.nameOf(name));
    }

    public void remove(String name, String postfix) {
        this.counters.remove(CounterRepo.nameOf(name, postfix));
    }

    public void remove(Class<?> clazz) {
        this.counters.remove(CounterRepo.nameOf(clazz));
    }

    public void remove(Class<?> clazz, String postfix) {
        this.counters.remove(CounterRepo.nameOf(clazz, postfix));
    }

    public Collection<Counter> getCounters() {
        return new ArrayList<Counter>(this.counters.values());
    }

    public void clear() {
        this.counters.clear();
    }

    private static String nameOf(String name) {
        return CounterRepo.nullOrEmpty(name) ? DEFAULT_NAME : name;
    }

    private static String nameOf(String name, String postfix) {
        String n = CounterRepo.nameOf(name);
        return CounterRepo.nullOrEmpty(postfix) ? n : n + ':' + postfix;
    }

    private static String nameOf(Class<?> clazz) {
        return clazz == null ? DEFAULT_NAME : clazz.getName();
    }

    private static String nameOf(Class<?> clazz, String postfix) {
        String n = CounterRepo.nameOf(clazz);
        return CounterRepo.nullOrEmpty(postfix) ? n : n + ':' + postfix;
    }

    private static final boolean nullOrEmpty(String s) {
        return s == null || s.isEmpty();
    }
}

